/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http.internal.frame;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jdk.incubator.http.internal.common.ByteBufferReference;
import jdk.incubator.http.internal.frame.ContinuationFrame;
import jdk.incubator.http.internal.frame.DataFrame;
import jdk.incubator.http.internal.frame.GoAwayFrame;
import jdk.incubator.http.internal.frame.HeaderFrame;
import jdk.incubator.http.internal.frame.HeadersFrame;
import jdk.incubator.http.internal.frame.Http2Frame;
import jdk.incubator.http.internal.frame.PingFrame;
import jdk.incubator.http.internal.frame.PriorityFrame;
import jdk.incubator.http.internal.frame.PushPromiseFrame;
import jdk.incubator.http.internal.frame.ResetFrame;
import jdk.incubator.http.internal.frame.SettingsFrame;
import jdk.incubator.http.internal.frame.WindowUpdateFrame;

public class FramesEncoder {
    private static final int NO_FLAGS = 0;
    private static final int ZERO_STREAM = 0;

    public ByteBufferReference[] encodeFrames(List<HeaderFrame> list) {
        ArrayList<ByteBufferReference> arrayList = new ArrayList<ByteBufferReference>(list.size() * 2);
        for (HeaderFrame headerFrame : list) {
            arrayList.addAll(Arrays.asList(this.encodeFrame(headerFrame)));
        }
        return arrayList.toArray(new ByteBufferReference[0]);
    }

    public ByteBufferReference encodeConnectionPreface(byte[] byArray, SettingsFrame settingsFrame) {
        int n = settingsFrame.length();
        ByteBufferReference byteBufferReference = this.getBuffer(9 + n + byArray.length);
        ByteBuffer byteBuffer = byteBufferReference.get();
        byteBuffer.put(byArray);
        this.putSettingsFrame(byteBuffer, settingsFrame, n);
        byteBuffer.flip();
        return byteBufferReference;
    }

    public ByteBufferReference[] encodeFrame(Http2Frame http2Frame) {
        switch (http2Frame.type()) {
            case 0: {
                return this.encodeDataFrame((DataFrame)http2Frame);
            }
            case 1: {
                return this.encodeHeadersFrame((HeadersFrame)http2Frame);
            }
            case 2: {
                return this.encodePriorityFrame((PriorityFrame)http2Frame);
            }
            case 3: {
                return this.encodeResetFrame((ResetFrame)http2Frame);
            }
            case 4: {
                return this.encodeSettingsFrame((SettingsFrame)http2Frame);
            }
            case 5: {
                return this.encodePushPromiseFrame((PushPromiseFrame)http2Frame);
            }
            case 6: {
                return this.encodePingFrame((PingFrame)http2Frame);
            }
            case 7: {
                return this.encodeGoAwayFrame((GoAwayFrame)http2Frame);
            }
            case 8: {
                return this.encodeWindowUpdateFrame((WindowUpdateFrame)http2Frame);
            }
            case 9: {
                return this.encodeContinuationFrame((ContinuationFrame)http2Frame);
            }
        }
        throw new UnsupportedOperationException("Not supported frame " + http2Frame.type() + " (" + http2Frame.getClass().getName() + ")");
    }

    private ByteBufferReference[] encodeDataFrame(DataFrame dataFrame) {
        assert (dataFrame.streamid() != 0);
        ByteBufferReference byteBufferReference = this.encodeDataFrameStart(dataFrame);
        if (dataFrame.getFlag(8)) {
            return this.joinWithPadding(byteBufferReference, dataFrame.getData(), dataFrame.getPadLength());
        }
        return this.join(byteBufferReference, dataFrame.getData());
    }

    private ByteBufferReference encodeDataFrameStart(DataFrame dataFrame) {
        boolean bl = dataFrame.getFlag(8);
        int n = dataFrame.getDataLength() + (bl ? dataFrame.getPadLength() + 1 : 0);
        ByteBufferReference byteBufferReference = this.getBuffer(9 + (bl ? 1 : 0));
        ByteBuffer byteBuffer = byteBufferReference.get();
        this.putHeader(byteBuffer, n, 0, dataFrame.getFlags(), dataFrame.streamid());
        if (bl) {
            byteBuffer.put((byte)dataFrame.getPadLength());
        }
        byteBuffer.flip();
        return byteBufferReference;
    }

    private ByteBufferReference[] encodeHeadersFrame(HeadersFrame headersFrame) {
        assert (headersFrame.streamid() != 0);
        ByteBufferReference byteBufferReference = this.encodeHeadersFrameStart(headersFrame);
        if (headersFrame.getFlag(8)) {
            return this.joinWithPadding(byteBufferReference, headersFrame.getHeaderBlock(), headersFrame.getPadLength());
        }
        return this.join(byteBufferReference, headersFrame.getHeaderBlock());
    }

    private ByteBufferReference encodeHeadersFrameStart(HeadersFrame headersFrame) {
        boolean bl = headersFrame.getFlag(8);
        boolean bl2 = headersFrame.getFlag(32);
        int n = headersFrame.getHeaderLength() + (bl ? headersFrame.getPadLength() + 1 : 0) + (bl2 ? 5 : 0);
        ByteBufferReference byteBufferReference = this.getBuffer(9 + (bl ? 1 : 0) + (bl2 ? 5 : 0));
        ByteBuffer byteBuffer = byteBufferReference.get();
        this.putHeader(byteBuffer, n, 1, headersFrame.getFlags(), headersFrame.streamid());
        if (bl) {
            byteBuffer.put((byte)headersFrame.getPadLength());
        }
        if (bl2) {
            this.putPriority(byteBuffer, headersFrame.getExclusive(), headersFrame.getStreamDependency(), headersFrame.getWeight());
        }
        byteBuffer.flip();
        return byteBufferReference;
    }

    private ByteBufferReference[] encodePriorityFrame(PriorityFrame priorityFrame) {
        assert (priorityFrame.streamid() != 0);
        ByteBufferReference byteBufferReference = this.getBuffer(14);
        ByteBuffer byteBuffer = byteBufferReference.get();
        this.putHeader(byteBuffer, 5, 2, 0, priorityFrame.streamid());
        this.putPriority(byteBuffer, priorityFrame.exclusive(), priorityFrame.streamDependency(), priorityFrame.weight());
        byteBuffer.flip();
        return new ByteBufferReference[]{byteBufferReference};
    }

    private ByteBufferReference[] encodeResetFrame(ResetFrame resetFrame) {
        assert (resetFrame.streamid() != 0);
        ByteBufferReference byteBufferReference = this.getBuffer(13);
        ByteBuffer byteBuffer = byteBufferReference.get();
        this.putHeader(byteBuffer, 4, 3, 0, resetFrame.streamid());
        byteBuffer.putInt(resetFrame.getErrorCode());
        byteBuffer.flip();
        return new ByteBufferReference[]{byteBufferReference};
    }

    private ByteBufferReference[] encodeSettingsFrame(SettingsFrame settingsFrame) {
        assert (settingsFrame.streamid() == 0);
        int n = settingsFrame.length();
        ByteBufferReference byteBufferReference = this.getBuffer(9 + n);
        ByteBuffer byteBuffer = byteBufferReference.get();
        this.putSettingsFrame(byteBuffer, settingsFrame, n);
        byteBuffer.flip();
        return new ByteBufferReference[]{byteBufferReference};
    }

    private ByteBufferReference[] encodePushPromiseFrame(PushPromiseFrame pushPromiseFrame) {
        assert (pushPromiseFrame.streamid() != 0);
        boolean bl = pushPromiseFrame.getFlag(8);
        int n = pushPromiseFrame.getHeaderLength() + (bl ? 5 : 4);
        ByteBufferReference byteBufferReference = this.getBuffer(9 + (bl ? 5 : 4));
        ByteBuffer byteBuffer = byteBufferReference.get();
        this.putHeader(byteBuffer, n, 5, pushPromiseFrame.getFlags(), pushPromiseFrame.streamid());
        if (bl) {
            byteBuffer.put((byte)pushPromiseFrame.getPadLength());
        }
        byteBuffer.putInt(pushPromiseFrame.getPromisedStream());
        byteBuffer.flip();
        if (pushPromiseFrame.getFlag(8)) {
            return this.joinWithPadding(byteBufferReference, pushPromiseFrame.getHeaderBlock(), pushPromiseFrame.getPadLength());
        }
        return this.join(byteBufferReference, pushPromiseFrame.getHeaderBlock());
    }

    private ByteBufferReference[] encodePingFrame(PingFrame pingFrame) {
        assert (pingFrame.streamid() == 0);
        ByteBufferReference byteBufferReference = this.getBuffer(17);
        ByteBuffer byteBuffer = byteBufferReference.get();
        this.putHeader(byteBuffer, 8, 6, pingFrame.getFlags(), 0);
        byteBuffer.put(pingFrame.getData());
        byteBuffer.flip();
        return new ByteBufferReference[]{byteBufferReference};
    }

    private ByteBufferReference[] encodeGoAwayFrame(GoAwayFrame goAwayFrame) {
        assert (goAwayFrame.streamid() == 0);
        byte[] byArray = goAwayFrame.getDebugData();
        int n = 8 + byArray.length;
        ByteBufferReference byteBufferReference = this.getBuffer(9 + n);
        ByteBuffer byteBuffer = byteBufferReference.get();
        this.putHeader(byteBuffer, n, 7, 0, 0);
        byteBuffer.putInt(goAwayFrame.getLastStream());
        byteBuffer.putInt(goAwayFrame.getErrorCode());
        if (byArray.length > 0) {
            byteBuffer.put(byArray);
        }
        byteBuffer.flip();
        return new ByteBufferReference[]{byteBufferReference};
    }

    private ByteBufferReference[] encodeWindowUpdateFrame(WindowUpdateFrame windowUpdateFrame) {
        ByteBufferReference byteBufferReference = this.getBuffer(13);
        ByteBuffer byteBuffer = byteBufferReference.get();
        this.putHeader(byteBuffer, 4, 8, 0, windowUpdateFrame.streamid);
        byteBuffer.putInt(windowUpdateFrame.getUpdate());
        byteBuffer.flip();
        return new ByteBufferReference[]{byteBufferReference};
    }

    private ByteBufferReference[] encodeContinuationFrame(ContinuationFrame continuationFrame) {
        assert (continuationFrame.streamid() != 0);
        int n = continuationFrame.getHeaderLength();
        ByteBufferReference byteBufferReference = this.getBuffer(9);
        ByteBuffer byteBuffer = byteBufferReference.get();
        this.putHeader(byteBuffer, n, 9, continuationFrame.getFlags(), continuationFrame.streamid());
        byteBuffer.flip();
        return this.join(byteBufferReference, continuationFrame.getHeaderBlock());
    }

    private ByteBufferReference[] joinWithPadding(ByteBufferReference byteBufferReference, ByteBufferReference[] byteBufferReferenceArray, int n) {
        ByteBufferReference[] byteBufferReferenceArray2 = new ByteBufferReference[2 + byteBufferReferenceArray.length];
        byteBufferReferenceArray2[0] = byteBufferReference;
        System.arraycopy(byteBufferReferenceArray, 0, byteBufferReferenceArray2, 1, byteBufferReferenceArray.length);
        assert (byteBufferReferenceArray2[byteBufferReferenceArray2.length - 1] == null);
        byteBufferReferenceArray2[byteBufferReferenceArray2.length - 1] = this.getPadding(n);
        return byteBufferReferenceArray2;
    }

    private ByteBufferReference[] join(ByteBufferReference byteBufferReference, ByteBufferReference[] byteBufferReferenceArray) {
        ByteBufferReference[] byteBufferReferenceArray2 = new ByteBufferReference[1 + byteBufferReferenceArray.length];
        byteBufferReferenceArray2[0] = byteBufferReference;
        System.arraycopy(byteBufferReferenceArray, 0, byteBufferReferenceArray2, 1, byteBufferReferenceArray.length);
        return byteBufferReferenceArray2;
    }

    private void putSettingsFrame(ByteBuffer byteBuffer, SettingsFrame settingsFrame, int n) {
        assert (settingsFrame.streamid() == 0);
        this.putHeader(byteBuffer, n, 4, settingsFrame.getFlags(), 0);
        settingsFrame.toByteBuffer(byteBuffer);
    }

    private void putHeader(ByteBuffer byteBuffer, int n, int n2, int n3, int n4) {
        int n5 = (n << 8) + n2;
        byteBuffer.putInt(n5);
        byteBuffer.put((byte)n3);
        byteBuffer.putInt(n4);
    }

    private void putPriority(ByteBuffer byteBuffer, boolean bl, int n, int n2) {
        byteBuffer.putInt(bl ? Integer.MIN_VALUE + n : n);
        byteBuffer.put((byte)n2);
    }

    private ByteBufferReference getBuffer(int n) {
        return ByteBufferReference.of(ByteBuffer.allocate(n));
    }

    public ByteBufferReference getPadding(int n) {
        if (n > 255) {
            throw new IllegalArgumentException("Padding too big");
        }
        return ByteBufferReference.of(ByteBuffer.allocate(n));
    }
}

