/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.html.DomChangeEvent;
import com.gargoylesoftware.htmlunit.html.DomChangeListener;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeEvent;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeListener;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.xpath.XPathUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.functors.NOPTransformer;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DomNodeList
implements NodeList,
Serializable {
    private static final long serialVersionUID = 1541399090797298342L;
    private String xpath_;
    private DomNode node_;
    private Transformer transformer_;
    private List<Object> cachedElements_;

    public DomNodeList(DomNode node, String xpath) {
        this(node, xpath, NOPTransformer.INSTANCE);
    }

    public DomNodeList(DomNode node, String xpath, Transformer transformer) {
        if (node != null) {
            this.node_ = node;
            this.xpath_ = xpath;
            this.transformer_ = transformer;
            DomHtmlAttributeChangeListenerImpl listener = new DomHtmlAttributeChangeListenerImpl();
            this.node_.addDomChangeListener(listener);
            if (this.node_ instanceof HtmlElement) {
                ((HtmlElement)this.node_).addHtmlAttributeChangeListener(listener);
                this.cachedElements_ = null;
            }
        }
    }

    private List<Object> getNodes() {
        if (this.cachedElements_ == null) {
            this.cachedElements_ = this.node_ != null ? XPathUtils.getByXPath(this.node_, this.xpath_) : new ArrayList<Object>();
        }
        return this.cachedElements_;
    }

    @Override
    public int getLength() {
        return this.getNodes().size();
    }

    @Override
    public Node item(int index) {
        return (DomNode)this.transformer_.transform(this.getNodes().get(index));
    }

    public String toString() {
        return "DomNodeList[" + this.xpath_ + "]";
    }

    private class DomHtmlAttributeChangeListenerImpl
    implements DomChangeListener,
    HtmlAttributeChangeListener {
        private DomHtmlAttributeChangeListenerImpl() {
        }

        public void nodeAdded(DomChangeEvent event) {
            DomNodeList.this.cachedElements_ = null;
        }

        public void nodeDeleted(DomChangeEvent event) {
            DomNodeList.this.cachedElements_ = null;
        }

        public void attributeAdded(HtmlAttributeChangeEvent event) {
            DomNodeList.this.cachedElements_ = null;
        }

        public void attributeRemoved(HtmlAttributeChangeEvent event) {
            DomNodeList.this.cachedElements_ = null;
        }

        public void attributeReplaced(HtmlAttributeChangeEvent event) {
            DomNodeList.this.cachedElements_ = null;
        }
    }
}

