/*
 * Copyright (c) 2009, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

/*
 * $Id: EmployeeELResolver.java 67375 2012-08-29 16:30:04Z dougd $
 */

package com.sun.ts.tests.el.common.elresolver;

import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import java.util.Iterator;

/* This simple EL Resolver resolves only method expressions of
 * the form ${worker.methodName}, where 'worker' is resolved to
 * com.sun.ts.tests.el.spec.language.EmployeeBean and 'methodName' is one of its
 * methods.
 */

public class EmployeeELResolver extends ELResolver {
    
    private static final String FIRST_NAME = "Ricky";
    private static final String LAST_NAME = "Bobby";
    
    public Object getValue(ELContext context, Object base, Object property)
    throws ELException {
        if (context == null) throw new NullPointerException();
        
        Object result = null;
        String propertyName = property.toString();
        
        if (base == null) {
            // Resolving first variable (e.g. ${worker}).
            if ("worker".equals(propertyName)) {
                result = "worker has no name!";
            }
            
        } else if ((base instanceof String) &&
                ("firstName".equals(property))) {
            
            result = EmployeeELResolver.FIRST_NAME;
            
        } else if ((base instanceof String) &&
                ("lastName".equals(property))) {
            
            result = EmployeeELResolver.LAST_NAME;
        }
        
        if (result != null) context.setPropertyResolved(true);
        return result;
    }
    
    
    public Class<?> getType(ELContext context, Object base, Object property)
    throws ELException {
        if (context == null) throw new NullPointerException();
        
        String propertyName = property.toString();
        if ((base == null && propertyName.equals("worker")) ||
                (base instanceof String && base.equals("worker")))
            context.setPropertyResolved(true);
        
        // we never set a value
        return null;
    }
    
    public void setValue(ELContext context, Object base, Object property,
            Object value) {
        if (context == null) throw new NullPointerException();
        
        if ((base == null && "worker".equals(property)) ||
                (base instanceof String && base.equals("worker")))
            context.setPropertyResolved(true);
    }
    
    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (context == null) throw new NullPointerException();
        
        String propertyName = property.toString();
        if ((base == null && propertyName.equals("worker")) ||
                (base instanceof String && base.equals("worker")))
            context.setPropertyResolved(true);
        return true;
    }
    
    public Iterator getFeatureDescriptors(ELContext context, Object base) {
        return null;
    }
    
    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base == null) return Object.class;
        return null;
    }
}
