/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: RemoteComponentPropFile.java 62564 2011-04-18 20:29:25Z kgrucci $
 */
package com.sun.ts.lib.tests.jbi;

import java.util.*;
import java.io.*;
import javax.jbi.component.ComponentContext;
import javax.jbi.JBIException;

public abstract class RemoteComponentPropFile extends RemoteComponent {
    
    public RemoteComponentPropFile() {
    }
    
    // override initProps from RemoteComponent and read the props from a props
    // file written to disk by the extension MBean.  Template Method called from
    // RemoteComponent.init();
    protected void initProps() throws Exception {
	Properties props = new Properties();
	InputStream ins = null;
	String installRoot = ctx.getInstallRoot();
	File propFile = new File(installRoot + File.separator + "config.props");
	try {
	    ins = new FileInputStream(propFile);
	    props.load(ins);
	    host = props.getProperty(Constants.RMI_HOST_NAME, "localhost");
	    port = Integer.parseInt(props.getProperty(Constants.RMI_PORT_NAME, "1099"));
	    name = props.getProperty(Constants.RMI_BIND_NAME, "DEFAULT");
	} finally {
	    try { ins.close(); } catch(Exception e) { /* do nothing */ }
	}
    }
    
}
