/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
/*
 * $Id: BusinessBeanBase.java 62595 2011-04-20 20:38:55Z kgrucci $
 */

package com.sun.ts.tests.ejb30.common.busiface;

import javax.ejb.EJBException;

/*
 * This class should not implement any more interfaces. Its superclass
 * BusinessLocal1Base still implements BusinessLocalIF1.  It should be the 
 * only interface implemented by this class.
 * All subclasses should either use @Remote/@Local annotations, or use ejb-jar
 * descriptor elements to declare its remote/local interfaces.
 */
abstract public class BusinessBeanBase extends BusinessLocal1Base
// implements BusinessIF1, BusinessIF2,
// BusinessLocalIF1, BusinessLocalIF2,
// AnnotatedLocalBusinessInterface1, AnnotatedLocalBusinessInterface2,
// AnnotatedBusinessInterface1, AnnotatedBusinessInterface2
{
    public boolean _businessMethod1_(String[] s) {
        resetValue(s);
        return true;
    }

    public String[] businessMethodLocal2(String[] s) {
        resetValue(s);
        return s;
    }

    public boolean businessMethod2(String[] s) {
        resetValue(s);
        return true;
    }

    public boolean annotatedBusinessInterfaceMethod(String[] s) {
        resetValue(s);
        return true;
    }

    public void afterCompletion(boolean b) throws EJBException {
        throw new EJBException("This method should not be called since this bean"
                + " does not implement SessionSynchronization.");
    }

    public void beforeCompletion() throws EJBException {
        throw new EJBException("This method should not be called since this bean"
                + " does not implement SessionSynchronization.");
    }

    public void afterBegin() throws EJBException {
        throw new EJBException("This method should not be called since this bean"
                + " does not implement SessionSynchronization.");
    }
}
