/*
 * Copyright (c) 2007, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: DoneLatch.java 65045 2012-02-20 18:18:04Z af70133 $
 */
package com.sun.ts.tests.jms.common;
import com.sun.ts.lib.util.*;
import com.sun.ts.lib.porting.*;
import com.sun.ts.lib.harness.*;
import java.io.*;
import java.rmi.RemoteException;
import java.util.*;
import com.sun.javatest.Status;
import javax.jms.*;

/**
 * Monitor class for asynchronous examples.  Producer signals end of
 * message stream; listener calls allDone() to notify consumer that the
 * signal has arrived, while consumer calls waitTillDone() to wait for this
 * notification.
 */
public class DoneLatch {
    boolean done = false;

    /**
     * Waits until done is set to true.
     */
    public void waitTillDone() {
        synchronized (this) {
            while (!done) {
                try {
                    this.wait();
                } catch (InterruptedException ie) {}
            }
        }
    }

    /**
     * Sets done to true.
     */
    public void allDone() {
        synchronized (this) {
            done = true;
            this.notify();
        }
    }

}
