/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.interview;

import com.sun.interview.ChoiceQuestion;
import com.sun.interview.FileQuestion;
import com.sun.interview.FinalQuestion;
import com.sun.interview.NullQuestion;
import com.sun.interview.Question;
import com.sun.interview.StringQuestion;
import com.sun.jck.interview.CompilerInterview;
import com.sun.jck.interview.EnvironmentInterview;
import com.sun.jck.interview.GroupModeSupport;
import com.sun.jck.interview.JCKEnvInterview;
import com.sun.jck.interview.JCKParameters;
import com.sun.jck.interview.TestPlatformInterview;
import com.sun.jck.interview.Utils;
import java.io.File;
import java.util.Map;

class CompilerRefExecuteInterview
extends JCKEnvInterview {
    GroupModeSupport groupModeSupport;
    private Question qIntro = new NullQuestion(this, "intro"){

        public void export(Map map) {
            if (CompilerRefExecuteInterview.this.parent.isRMIC()) {
                map.put("command.refExecute.securityPolicy", "$testSuiteRootDir$/lib$/jck.policy");
            }
            map.put("command.refExecute", CompilerRefExecuteInterview.this.buildCommand(false));
            TestPlatformInterview testPlatformInterview = CompilerRefExecuteInterview.this.parent.getTestCompileInterview().getTestPlatformInterview();
            boolean bl = (testPlatformInterview.isGroupMode() || !testPlatformInterview.isMultiJVM()) && CompilerRefExecuteInterview.this.groupModeSupport.isGroupModeEnabled();
            map.put("refExecute.isGroupMode", String.valueOf(bl));
            if (bl) {
                map.put("command.refExecute.group", CompilerRefExecuteInterview.this.buildCommand(true));
            }
            map.put("refFileSeparator", String.valueOf(CompilerRefExecuteInterview.this.getFileSep()));
            map.put("pathTo.refjava", Utils.adjust(CompilerRefExecuteInterview.this.qCmdAsFile.getValue().getPath()));
        }

        protected Question getNext() {
            return CompilerRefExecuteInterview.this.qCmdAsFile;
        }
    };
    private FileQuestion qCmdAsFile = new FileQuestion(this, "cmdAsFile"){

        public File getValue() {
            File file;
            if (CompilerRefExecuteInterview.this.parent != null && CompilerRefExecuteInterview.this.parent.getTestCompileInterview() != null && (file = CompilerRefExecuteInterview.this.parent.getTestCompileInterview().getCompilerPathName()) != null && file.getParentFile() != null) {
                this.setBaseDirectory(file.getParentFile());
            }
            return super.getValue();
        }

        public void setValue(File file) {
            if (file == null || file.getPath().length() == 0) {
                super.setValue(file);
            } else {
                File file2;
                file = file2 = this.getAdjustedValue(file);
            }
            super.setValue(file);
        }

        private File getAdjustedValue(File file) {
            if (file == null) {
                return null;
            }
            if (!file.isAbsolute()) {
                return new File(this.getBaseDirectory(), file.getPath());
            }
            return file;
        }

        protected Question getNext() {
            if (this.value == null || this.value.getPath().length() == 0) {
                return null;
            }
            if (CompilerRefExecuteInterview.this.getRootInterview().isErrorCheckingEnabled() && !this.value.isFile()) {
                return ((CompilerRefExecuteInterview)CompilerRefExecuteInterview.this).parent.qNoFileError;
            }
            return CompilerRefExecuteInterview.this.qVersion;
        }

        public File[] getSuggestions() {
            File file;
            File[] fileArray = super.getSuggestions();
            boolean bl = CompilerRefExecuteInterview.this.parent.isSimple();
            if (bl && fileArray == null && (file = this.getDefValue()) != null) {
                return new File[]{new File(""), file};
            }
            return null;
        }

        private File getDefValue() {
            String string;
            File file;
            File file2 = CompilerRefExecuteInterview.this.parent.getTestCompileInterview().getJavaHome();
            String string2 = CompilerRefExecuteInterview.this.parent.getTestPlatformInterview().getOS();
            if (file2 != null && string2 != null && this.isValueValid(file = new File(new File(file2, "bin"), string = EnvironmentInterview.isWindows(string2) ? "java.exe" : "java"))) {
                return file;
            }
            return null;
        }

        private boolean isValueValid(File file) {
            try {
                return file != null && file.getPath().length() != 0 && file.isFile();
            }
            catch (SecurityException securityException) {
                return false;
            }
        }
    };
    private ChoiceQuestion qVersion = new ChoiceQuestion(this, "version"){
        {
            this.setChoices(new String[]{"JDK 1.1, JDK 1.1.x", "JDK 1.2, JDK 1.2.x", "JDK 1.3, JDK 1.3.x", "JDK 1.4, JDK 1.4.x", "JDK 1.5, JDK 1.5.x", "JDK 1.6, JDK 1.6.x"});
        }

        protected Question getNext() {
            return CompilerRefExecuteInterview.this.qOSEnv();
        }

        public boolean isHidden() {
            this.setValue(this.getDefValue());
            return true;
        }

        private String getDefValue() {
            return this.getChoices()[5];
        }
    };
    private StringQuestion qSystemRoot = new StringQuestion(this, "systemRoot"){
        {
            this.setSuggestions(new String[]{"", "C:\\Windows", "C:\\WindowsNT", "C:\\WinNT"});
        }

        protected Question getNext() {
            if (this.value == null || this.value.length() == 0) {
                return null;
            }
            return CompilerRefExecuteInterview.this.qOtherOpts;
        }
    };
    private StringQuestion qFileSep = new StringQuestion(this, "fileSep"){
        {
            this.setSuggestions(new String[]{"", "/", "\\"});
            this.setNominalMaxLength(1);
        }

        protected Question getNext() {
            if (this.value == null || this.value.length() != 1) {
                return null;
            }
            return CompilerRefExecuteInterview.this.qPathSep;
        }
    };
    private StringQuestion qPathSep = new StringQuestion(this, "pathSep"){
        {
            this.setSuggestions(new String[]{"", ":", ";"});
            this.setNominalMaxLength(1);
        }

        protected Question getNext() {
            if (this.value == null || this.value.length() != 1) {
                return null;
            }
            return CompilerRefExecuteInterview.this.qOtherOpts;
        }
    };
    private StringQuestion qOtherOpts = new StringQuestion(this, "otherOpts"){
        {
            this.setDefaultValue("");
        }

        protected Question getNext() {
            return CompilerRefExecuteInterview.this.qOtherEnvVars;
        }
    };
    StringQuestion qOtherEnvVars = new StringQuestion(this, "otherEnvVars"){
        {
            this.setDefaultValue("");
        }

        protected Question getNext() {
            return CompilerRefExecuteInterview.this.qEnd;
        }
    };
    private Question qEnd = new FinalQuestion(this);
    private CompilerInterview parent;

    CompilerRefExecuteInterview(CompilerInterview compilerInterview) {
        super(compilerInterview, "compRefExecute");
        this.parent = compilerInterview;
        this.setFirstQuestion(this.qIntro);
        this.groupModeSupport = new GroupModeSupport(this);
    }

    JCKParameters getRootInterview() {
        return this.parent.getRootInterview();
    }

    private String buildCommand(boolean bl) {
        char c = this.getFileSep();
        char c2 = this.getPathSep();
        String string = Utils.adjust(this.getRootInterview().getWorkDirectory().getPath()) + c + "classes";
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            this.groupModeSupport.appendArguments(stringBuffer);
        } else {
            stringBuffer.append("com.sun.jck.lib.ExecJCKTestOtherJVMCmd ");
        }
        if (bl) {
            stringBuffer.append("-MENV_ ");
            stringBuffer.append("CLASSPATH");
            stringBuffer.append('=');
            stringBuffer.append("$testSuiteRootDir" + c + "lib" + c + "javatest.jar" + c2 + "$testSuiteRootDir" + c + "lib" + c + "jtjck.jar ");
        } else {
            stringBuffer.append("CLASSPATH");
            stringBuffer.append('=');
            stringBuffer.append(string + c2 + "$testSuiteRootDir" + c + "classes" + c2 + "$testSuiteRootDir" + c + "lib" + c + "javatest.jar ");
        }
        this.appendEnvVars(stringBuffer);
        if (bl) {
            stringBuffer.append("-MCMD_ ");
        }
        this.appendCmd(stringBuffer);
        if (bl) {
            stringBuffer.append("-MTEST_ com.sun.jck.lib.ExecJCKTestSameJVMCmd ");
            stringBuffer.append("-loadDir $testSuiteRootDir" + c + "classes ");
            stringBuffer.append("-loadImpl " + string + " ");
        }
        stringBuffer.append("$testExecuteClass $testExecuteArgs");
        return stringBuffer.toString();
    }

    private void appendEnvVars(StringBuffer stringBuffer) {
        String string = this.getOS();
        if (EnvironmentInterview.isWindows(string)) {
            stringBuffer.append("SystemRoot=");
            stringBuffer.append(this.qSystemRoot.getValue());
            stringBuffer.append(' ');
        }
        Utils.appendValue(stringBuffer, this.qOtherEnvVars.getValue());
    }

    private void appendCmd(StringBuffer stringBuffer) {
        stringBuffer.append(Utils.adjust(this.qCmdAsFile.getValue().getPath()));
        stringBuffer.append(' ');
        Utils.appendValue(stringBuffer, this.qOtherOpts.getValue());
        String string = this.qVersion.getValue();
        String string2 = null;
        if (string.startsWith("JDK 1.1")) {
            string2 = "-verify";
        } else if (string.startsWith("JDK 1.2") || string.startsWith("JDK 1.3") || string.startsWith("JDK 1.4") || string.startsWith("JDK 1.5") || string.startsWith("JDK 1.6")) {
            string2 = "-Xfuture";
        }
        if (string2 != null) {
            stringBuffer.append(string2);
            stringBuffer.append(' ');
        }
        if (this.parent.isRMIC()) {
            stringBuffer.append("-Djava.security.policy=${command.refExecute.securityPolicy}");
            stringBuffer.append(' ');
        }
    }

    private Question qOSEnv() {
        String string = this.getOS();
        if (string == null) {
            return this.qFileSep;
        }
        if (EnvironmentInterview.isWindows(string)) {
            return this.qSystemRoot;
        }
        return this.qOtherOpts;
    }

    String getOS() {
        return EnvironmentInterview.localOSName;
    }

    char getFileSep() {
        String string = this.getOS();
        if (string == null) {
            String string2 = this.qFileSep.getValue();
            return string2 == null ? (char)'/' : string2.charAt(0);
        }
        return EnvironmentInterview.getFileSep(string);
    }

    char getPathSep() {
        String string = this.getOS();
        if (string == null) {
            String string2 = this.qPathSep.getValue();
            return string2 == null ? (char)':' : string2.charAt(0);
        }
        return EnvironmentInterview.getPathSep(string);
    }
}

