/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.interview;

import com.sun.javatest.JavaTestError;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.ListResourceBundle;
import java.util.ResourceBundle;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class JCKResourceBundle
extends ListResourceBundle {
    static final String RESOURCES_PATH = "resources";
    static final String SMRY_PROP_POSTFIX = "smry";
    static final String TEXT_PROP_POSTFIX = "text";
    private Object[][] data;

    public JCKResourceBundle(Class clazz) {
        this(clazz, null);
    }

    public JCKResourceBundle(Class clazz, ResourceBundle resourceBundle) {
        if (clazz == null) {
            throw new NullPointerException("Constructor parameter is NULL");
        }
        if (resourceBundle != null) {
            this.setParent(resourceBundle);
        }
        try {
            InputStream inputStream = JCKResourceBundle.getInputStream(clazz);
            this.parse(inputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string = "Cannot parse XML descriptor for interview class " + clazz + ": " + exception.getMessage();
            throw new JavaTestError(string, exception);
        }
    }

    protected Object[][] getContents() {
        return this.data;
    }

    protected static InputStream getInputStream(Class clazz) {
        String string = clazz.getPackage().getName();
        String string2 = clazz.getCanonicalName();
        if (string2.indexOf(string) != 0) {
            throw new IllegalStateException("Interview class '" + string2 + "' doesn't match its package '" + string + "'");
        }
        String string3 = string.replace('.', '/');
        String string4 = string2.substring(string.length() + 1) + ".xml";
        final String string5 = string3 + '/' + RESOURCES_PATH + '/' + string4;
        final ClassLoader classLoader = clazz.getClassLoader();
        InputStream inputStream = (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return classLoader.getResourceAsStream(string5);
            }
        });
        if (inputStream == null) {
            throw new NullPointerException("Resource '" + string5 + "' cannot be found!");
        }
        return inputStream;
    }

    protected void parse(InputStream inputStream) throws SAXException, IOException, ParserConfigurationException {
        int n;
        DocumentBuilder documentBuilder = JCKResourceBundle.getDocumentBuilder();
        Document document = documentBuilder.parse(inputStream);
        Element element = document.getDocumentElement();
        if (element == null) {
            return;
        }
        String string = element.getAttribute("name");
        ArrayList<Element> arrayList = new ArrayList<Element>();
        NodeList nodeList = element.getChildNodes();
        int n2 = nodeList.getLength();
        for (n = 0; n < n2; ++n) {
            Node node = nodeList.item(n);
            if (!(node instanceof Element)) continue;
            arrayList.add((Element)node);
        }
        n = arrayList.size();
        if (n == 0) {
            return;
        }
        this.data = new Object[n * 2][2];
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)arrayList.get(i);
            String string2 = element2.getAttribute("name");
            NodeList nodeList2 = element2.getElementsByTagName(SMRY_PROP_POSTFIX);
            String string3 = nodeList2.getLength() > 0 ? nodeList2.item(0).getTextContent() : null;
            nodeList2 = element2.getElementsByTagName(TEXT_PROP_POSTFIX);
            String string4 = nodeList2.getLength() > 0 ? nodeList2.item(0).getTextContent() : null;
            String string5 = string + "." + string2 + ".";
            String string6 = string5 + SMRY_PROP_POSTFIX;
            String string7 = string5 + TEXT_PROP_POSTFIX;
            this.data[i * 2][0] = string6;
            this.data[i * 2][1] = string3;
            this.data[i * 2 + 1][0] = string7;
            this.data[i * 2 + 1][1] = string4;
        }
    }

    protected static DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        return documentBuilderFactory.newDocumentBuilder();
    }
}

