/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.interview;

import com.sun.interview.Checklist;
import com.sun.interview.FinalQuestion;
import com.sun.interview.Question;
import com.sun.interview.StringQuestion;
import com.sun.interview.YesNoQuestion;
import com.sun.jck.interview.JCKChoiceQuestion;
import com.sun.jck.interview.JCKEnvInterview;
import com.sun.jck.interview.RuntimeInterview;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;

class RuntimeAudioInterview
extends JCKEnvInterview {
    private Question qCanPlaySound = new YesNoQuestion(this, "canPlaySound"){

        protected void export(Map map) {
            boolean bl = this.value == "Yes";
            map.put("platform.canPlaySound", String.valueOf(bl));
            if (this.value == "No") {
                map.put("platform.soundURL", "$testSuiteRootDirURL$/tests$/api$/javax_sound$/sound.wav");
            }
        }

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            if (this.value == "Yes") {
                return RuntimeAudioInterview.this.qSoundURLChoice;
            }
            return RuntimeAudioInterview.this.qCanRecordSound;
        }
    };
    private Question qSoundURLChoice = new YesNoQuestion(this, "soundURLChoice"){

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            if (this.value == "Yes") {
                return RuntimeAudioInterview.this.qSoundURLYesJCK;
            }
            return RuntimeAudioInterview.this.qSoundURLNoJCK;
        }

        public boolean isHidden() {
            boolean bl = RuntimeAudioInterview.this.parent.isSimple();
            if (bl) {
                this.setValue(this.getDefValue());
            }
            return bl;
        }

        private String getDefValue() {
            return "Yes";
        }
    };
    private Question qSoundURLNoJCK = new StringQuestion(this, "soundURLNoJCK"){
        {
            this.setSuggestions(new String[]{"", "file:/home/sound.wav", "file:/c:/sound.wav"});
        }

        protected void export(Map map) {
            map.put("platform.soundURL", this.value);
        }

        protected Question getNext() {
            boolean bl;
            if (this.value == null || this.value.length() == 0) {
                return null;
            }
            try {
                URL uRL = new URL(this.value);
                bl = true;
            }
            catch (MalformedURLException malformedURLException) {
                bl = false;
            }
            return bl ? RuntimeAudioInterview.this.qCanRecordSound : null;
        }

        public Checklist.Item[] getChecklistItems() {
            Checklist.Item item;
            Checklist.Item[] itemArray = new Checklist.Item[1];
            String string = this.value;
            itemArray[0] = item = RuntimeAudioInterview.this.createChecklistItem("audioSection", "audioResource", string);
            return itemArray;
        }
    };
    private JCKChoiceQuestion qSoundURLYesJCK = new JCKChoiceQuestion(this, "soundURLYesJCK"){
        {
            this.setChoices(new String[]{null, ".WAV", ".AU", ".SND"});
        }

        public void export(Map map) {
            if (this.value != null && this.value.equals(".AU")) {
                map.put("platform.soundURL", "$testSuiteRootDirURL$/tests$/api$/javax_sound$/sound.au");
            }
            if (this.value != null && this.value.equals(".WAV")) {
                map.put("platform.soundURL", "$testSuiteRootDirURL$/tests$/api$/javax_sound$/sound.wav");
            }
            if (this.value != null && this.value.equals(".SND")) {
                map.put("platform.soundURL", "$testSuiteRootDirURL$/tests$/api$/javax_sound$/sound.snd");
            }
        }

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            return RuntimeAudioInterview.this.qCanRecordSound;
        }

        public boolean isHidden() {
            boolean bl = RuntimeAudioInterview.this.parent.isSimple();
            if (bl) {
                this.setValue(this.getDefValue());
            }
            return bl;
        }

        private String getDefValue() {
            return this.getChoices()[1];
        }
    };
    private Question qCanRecordSound = new YesNoQuestion(this, "canRecordSound"){

        protected void export(Map map) {
            boolean bl = this.value == "Yes";
            map.put("platform.canRecordSound", String.valueOf(bl));
        }

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            return RuntimeAudioInterview.this.qCanPlayMidi;
        }
    };
    private Question qCanPlayMidi = new YesNoQuestion(this, "canPlayMidi"){

        protected void export(Map map) {
            boolean bl = this.value == "Yes";
            map.put("platform.canPlayMidi", String.valueOf(bl));
        }

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            return RuntimeAudioInterview.this.qEnd;
        }
    };
    private Question qEnd = new FinalQuestion(this);
    private RuntimeInterview parent;

    RuntimeAudioInterview(RuntimeInterview runtimeInterview) {
        super(runtimeInterview, "audio");
        this.parent = runtimeInterview;
        this.setFirstQuestion(this.qCanPlaySound);
    }

    public void export(Map map) {
        super.export(map);
        if (this.parent.isSimple() && this.qSoundURLYesJCK.isHidden()) {
            this.qSoundURLYesJCK.export(map);
        }
    }
}

