/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.interview;

import com.sun.interview.DirectoryFileFilter;
import com.sun.interview.ExtensionFileFilter;
import com.sun.interview.FileFilter;
import com.sun.interview.FileListQuestion;
import com.sun.interview.FinalQuestion;
import com.sun.interview.Question;
import com.sun.interview.YesNoQuestion;
import com.sun.jck.interview.JCKEnvInterview;
import com.sun.jck.interview.RuntimeInterview;
import com.sun.jck.interview.TestPlatformInterview;
import com.sun.jck.interview.Utils;
import java.io.File;
import java.util.Map;

class RuntimeStaticSigTestInterview
extends JCKEnvInterview {
    private Question qSupportStaticSigTest = new YesNoQuestion(this, "supportStaticSigTest"){

        protected void export(Map map) {
            boolean bl = this.value == "Yes";
            map.put("platform.supportStaticSigTest", String.valueOf(bl));
        }

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            if (this.value == "Yes") {
                return RuntimeStaticSigTestInterview.this.qStaticSigTestClasspath;
            }
            return RuntimeStaticSigTestInterview.this.qEnd;
        }
    };
    private FileListQuestion qStaticSigTestClasspath = new FileListQuestion(this, "staticSigTestClasspath"){
        {
            FileFilter[] fileFilterArray = new FileFilter[]{new DirectoryFileFilter("Directories"), new ExtensionFileFilter(".zip", "ZIP Files"), new ExtensionFileFilter(".jar", "JAR Files")};
            this.setFilters(fileFilterArray);
        }

        public File getBaseDirectory() {
            return new File(System.getProperty("user.dir"));
        }

        protected void export(Map map) {
            File[] fileArray = this.getValue();
            TestPlatformInterview testPlatformInterview = RuntimeStaticSigTestInterview.this.parent.getTestPlatformInterview();
            char c = testPlatformInterview.getPathSep();
            String string = Utils.constructClasspath(fileArray, c);
            map.put("platform.staticSigTestClasspath", string);
        }

        protected Question getNext() {
            if (this.value == null || this.value.length == 0) {
                return null;
            }
            return RuntimeStaticSigTestInterview.this.qEnd;
        }
    };
    private Question qEnd = new FinalQuestion(this);
    private RuntimeInterview parent;

    RuntimeStaticSigTestInterview(RuntimeInterview runtimeInterview) {
        super(runtimeInterview, "staticsigtest");
        this.parent = runtimeInterview;
        this.setFirstQuestion(this.qSupportStaticSigTest);
    }
}

