/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.interview;

import java.io.File;

public class Utils {
    private Utils() {
    }

    public static String constructClasspath(File[] fileArray, char c) {
        if (fileArray == null || fileArray.length == 0) {
            return "";
        }
        int n = fileArray.length - 1;
        for (int i = 0; i < fileArray.length; ++i) {
            n += fileArray[i].getPath().length();
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        stringBuffer.append("\"");
        stringBuffer.append(fileArray[0].getAbsolutePath());
        for (int i = 1; i < fileArray.length; ++i) {
            stringBuffer.append(c);
            stringBuffer.append(fileArray[i].getAbsolutePath());
        }
        stringBuffer.append("\"");
        return stringBuffer.toString();
    }

    public static String adjustForDollarSign(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer = new StringBuffer(string);
        int n = stringBuffer.lastIndexOf("$", stringBuffer.length());
        while (n != -1) {
            stringBuffer.replace(n, n + 1, "$$");
            n = stringBuffer.lastIndexOf("$", n - 1);
        }
        return stringBuffer.toString();
    }

    public static String adjustForSpace(String string) {
        if (string != null && string.indexOf(" ") > 0) {
            return "'" + string + "'";
        }
        return string;
    }

    public static String adjust(String string) {
        return Utils.adjustForSpace(Utils.adjustForDollarSign(string));
    }

    public static String replaceAll(String string, char c, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (stringBuffer.charAt(i) != c) continue;
            stringBuffer.replace(i, i + 1, string2);
            i += string2.length() - 1;
        }
        return stringBuffer.toString();
    }

    public static boolean isValidClassName(String string) {
        if (string == null || string.equals("")) {
            return false;
        }
        boolean bl = true;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '.') {
                bl = true;
                continue;
            }
            if (bl) {
                if (Character.isJavaIdentifierStart(c)) {
                    bl = false;
                    continue;
                }
                return false;
            }
            if (Character.isJavaIdentifierPart(c)) continue;
            return false;
        }
        return !bl;
    }

    public static boolean isValidMethodName(String string) {
        return Utils.isValidIdentifier(string);
    }

    public static boolean isValidIdentifier(String string) {
        if ("".equals(string)) {
            return false;
        }
        if (Utils.isJavaKeyword(string)) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            if (Character.isJavaIdentifierStart(string.charAt(i)) || Character.isJavaIdentifierPart(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isJavaKeyword(String string) {
        return "abstract".equals(string) || "boolean".equals(string) || "break".equals(string) || "byte".equals(string) || "case".equals(string) || "catch".equals(string) || "char".equals(string) || "class".equals(string) || "const".equals(string) || "continue".equals(string) || "default".equals(string) || "do".equals(string) || "double".equals(string) || "else".equals(string) || "extends".equals(string) || "final".equals(string) || "finally".equals(string) || "float".equals(string) || "for".equals(string) || "goto".equals(string) || "if".equals(string) || "implements".equals(string) || "import".equals(string) || "instanceof".equals(string) || "int".equals(string) || "interface".equals(string) || "long".equals(string) || "native".equals(string) || "new".equals(string) || "package".equals(string) || "private".equals(string) || "protected".equals(string) || "public".equals(string) || "return".equals(string) || "short".equals(string) || "static".equals(string) || "strictfp".equals(string) || "super".equals(string) || "switch".equals(string) || "synchronized".equals(string) || "this".equals(string) || "throw".equals(string) || "throws".equals(string) || "transient".equals(string) || "try".equals(string) || "void".equals(string) || "volatile".equals(string) || "while".equals(string);
    }

    public static boolean isValidTemplate(String string, char c) {
        int n = 0;
        if (string == null || string.length() == 0 || (n = string.indexOf(c)) == -1) {
            return false;
        }
        if (n < string.length() - 1 && string.indexOf(c, n + 1) != -1) {
            return false;
        }
        return !"".equals(Utils.replaceAll(string, c, "").trim());
    }

    public static boolean appendValue(StringBuffer stringBuffer, String ... stringArray) {
        boolean bl = false;
        for (String string : stringArray) {
            if (string == null || string.length() <= 0) continue;
            stringBuffer.append(string);
            stringBuffer.append(' ');
            bl = true;
        }
        return bl;
    }

    public static boolean appendKeyValue(StringBuffer stringBuffer, String string, String ... stringArray) {
        boolean bl = false;
        if (string != null && string.length() > 0) {
            stringBuffer.append('-');
            stringBuffer.append(string);
            stringBuffer.append(' ');
            bl = true;
        }
        return Utils.appendValue(stringBuffer, stringArray) || bl;
    }

    public static String encode(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        block4: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '%': 
                case '\'': 
                case '+': 
                case ',': {
                    stringBuilder.append("%" + Integer.toHexString(0xFF & c));
                    continue block4;
                }
                case ' ': {
                    stringBuilder.append('+');
                    continue block4;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static String evalTemplate(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + string2.length());
        int n = string.indexOf(35);
        stringBuffer.append(string.substring(0, n));
        stringBuffer.append(string2);
        if (n < string.length() - 1) {
            stringBuffer.append(string.substring(n + 1));
        }
        return stringBuffer.toString();
    }

    public static String evalTemplate(String string, char c, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + string2.length());
        int n = string.indexOf(c);
        stringBuffer.append(string.substring(0, n));
        stringBuffer.append(string2);
        if (n < string.length() - 1) {
            stringBuffer.append(string.substring(n + 1));
        }
        return stringBuffer.toString();
    }

    public static String evalTemplate(String string, String string2, String string3) {
        return Utils.evalTemplate(Utils.evalTemplate(string, '#', string2), '@', string3);
    }
}

