/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.lib;

import com.sun.javatest.Command;
import com.sun.javatest.Status;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CIncludeCommand
extends Command {
    private String testSource;
    private String testURL;
    private String tmpDir;

    protected void decodeAllArgs(String[] stringArray) {
        try {
            this.testSource = stringArray[0];
            this.testURL = stringArray[1];
            this.tmpDir = stringArray[2];
            Pattern pattern = Pattern.compile(".*(tests/vm/.*|tests/api/.*)");
            Matcher matcher = pattern.matcher(this.testSource);
            matcher.find();
            this.testSource = matcher.group(1);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("CIncludeCommand should have 3 input parameters: testSource, testURL, tmpDir");
        }
    }

    public static String getType(String string, String string2) throws IOException {
        String string3;
        Pattern pattern = Pattern.compile("file:[/]*([^#]*)");
        Matcher matcher = pattern.matcher(string2);
        matcher.find();
        String string4 = "/" + matcher.group(1);
        LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(string4));
        String string5 = null;
        while ((string3 = lineNumberReader.readLine()) != null) {
            if (string3.startsWith("Binary:")) {
                string5 = string3;
            }
            if (string3.startsWith("Binary:jckatr") || string3.startsWith("Binary:(jckatr)")) {
                string5 = "jckatr";
                break;
            }
            if (!string3.startsWith("Binary:jckjni") && !string3.startsWith("Binary:(jckjni)")) continue;
            string5 = "jckjni";
            break;
        }
        if (string5 == null) {
            string5 = string.contains("tests/vm/jvmti/") ? "jckjvmti" : "jckjni";
        }
        return string5;
    }

    protected void write() throws IOException {
        String string = CIncludeCommand.getType(this.testSource, this.testURL);
        System.out.println("CInclude: " + string);
        File file = new File(this.tmpDir, string);
        if (!file.exists()) {
            file.mkdirs();
        }
        File file2 = File.createTempFile("inc", null, file);
        FileWriter fileWriter = new FileWriter(file2);
        fileWriter.write(this.testSource);
        fileWriter.write(10);
        fileWriter.flush();
        System.out.println("Written " + file2.getAbsolutePath());
    }

    public Status run(String[] stringArray, PrintWriter printWriter, PrintWriter printWriter2) {
        this.decodeAllArgs(stringArray);
        try {
            this.write();
        }
        catch (IOException iOException) {
            iOException.printStackTrace(printWriter2);
            return Status.failed("Failed to register c include: " + this.testSource);
        }
        return Status.passed("ok");
    }

    public static void main(String[] stringArray) throws Exception {
        stringArray = new String[]{"tests/vm/jvmti/GetVersionNumber/gver001/gver00101/gver00101.c", "file:///export/home/dima/projects/common/out/tempTestStorage/tests/vm/jvmti/GetVersionNumber/gver001/gver00101/gver00101.html", "/tmp/dima-build/cincl"};
        CIncludeCommand cIncludeCommand = new CIncludeCommand();
        cIncludeCommand.run(stringArray, new PrintWriter(System.out), new PrintWriter(System.err));
    }
}

