/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.lib;

import com.sun.javatest.util.WriterStream;
import com.sun.jck.lib.Deprecated;
import com.sun.jck.lib.MessageClient;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javasoft.sqe.javatest.Status;
import javasoft.sqe.javatest.Test;

public class DistributedTest
implements Test {
    private String name;
    protected PrintWriter log;
    protected PrintWriter ref;
    private String msgSwitchAddr;
    private MessageClient msgClient;
    private Status msgStatus = Status.passed("OK");
    private static final Class[] handleXXXArgs = new Class[]{String.class, String[].class};

    protected DistributedTest() {
    }

    protected DistributedTest(String string) {
        this.name = string;
    }

    public Status run(String[] stringArray, PrintWriter printWriter, PrintWriter printWriter2) {
        this.log = printWriter;
        this.ref = printWriter2;
        try {
            this.decodeAllArgs(stringArray);
            this.msgClient = new MessageClient(this.name, this.msgSwitchAddr){

                public void handleMessage(String string, String[] stringArray) {
                    DistributedTest.this.handleMessage(string, stringArray);
                }

                public void handleException(Exception exception) {
                    DistributedTest.this.handleException("problem with message client", exception);
                }
            };
            Status status = this.go();
            return status.getType() >= this.msgStatus.getType() ? status : this.msgStatus;
        }
        catch (IOException iOException) {
            this.printStackTrace(iOException);
            return Status.error("Cannot start message client: " + iOException);
        }
        catch (Fault fault) {
            return Status.error(fault.getMessage());
        }
    }

    protected Status go() {
        this.msgClient.run();
        return Status.passed("OK");
    }

    protected final void decodeAllArgs(String[] stringArray) throws Fault {
        int n;
        for (int i = 0; i < stringArray.length; i += n) {
            n = this.decodeArg(stringArray, i);
            if (n != 0) continue;
            throw new Fault("Could not recognize argument: " + stringArray[i]);
        }
    }

    protected int decodeArg(String[] stringArray, int n) throws Fault {
        if (stringArray[n].equals("-msgSwitch")) {
            if (n + 1 < stringArray.length) {
                this.msgSwitchAddr = stringArray[++n];
                return 2;
            }
            throw new Fault("no value supplied for -msgSwitch");
        }
        return 0;
    }

    public void broadcast(String[] stringArray) throws IOException {
        this.msgClient.broadcast(stringArray);
    }

    public void send(String string, String[] stringArray) throws IOException {
        this.msgClient.send(string, stringArray);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (this.name != null) {
            throw new IllegalStateException("component already named");
        }
        this.name = string;
    }

    public void handleMessages() throws InterruptedException {
        this.msgClient.start();
    }

    protected Method getMethod(String string, Class[] classArray) throws NoSuchMethodException {
        Method method = this.getClass().getDeclaredMethod(string, classArray);
        return method;
    }

    protected void handleMessage(String string, String[] stringArray) {
        try {
            Method method = this.getMethod("handle_" + stringArray[0], handleXXXArgs);
            String[] stringArray2 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
            Status status = (Status)method.invoke((Object)this, string, stringArray2);
            if (status != null) {
                this.setMsgStatus(status);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            this.handleException("Cannot access code to handle message: " + stringArray[0], illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof Fault) {
                this.setMsgStatus(Status.failed(throwable.getMessage()));
            } else {
                this.handleException("Exception handling message: " + stringArray[0], throwable);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.handleUnknownMessage(string, stringArray);
        }
    }

    protected void handleUnknownMessage(String string, String[] stringArray) {
        this.log.println("unknown message: " + stringArray[0]);
        this.setMsgStatus(Status.error("unknown message: " + stringArray[0]));
    }

    protected void printStackTrace(Throwable throwable) {
        PrintStream printStream = Deprecated.createPrintStream(new WriterStream(this.log));
        throwable.printStackTrace(printStream);
        printStream.close();
    }

    protected void setMsgStatus(Status status) {
        if (status.getType() > this.msgStatus.getType()) {
            this.msgStatus = status;
        }
    }

    private void handleException(String string, Throwable throwable) {
        this.log.println(string);
        this.printStackTrace(throwable);
        this.setMsgStatus(Status.error(string));
    }

    public static class Fault
    extends Exception {
        public Fault(String string) {
            super(string);
        }
    }
}

