/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.lib;

import com.sun.javatest.ResourceTable;
import com.sun.javatest.Script;
import com.sun.javatest.Status;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestResult;
import com.sun.javatest.util.StringArray;
import com.sun.jck.lib.scriptgen.ScriptGen;
import java.io.File;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;

public abstract class IntermediateScript
extends Script {
    private ScriptGen scriptGen = null;
    private boolean isNegative = false;
    protected int product;
    private static ResourceTable lockTable = new ResourceTable();

    protected void start(String[] stringArray, TestDescription testDescription, TestEnvironment testEnvironment) {
        this.isNegative = testDescription.getKeywordTable().contains("negative");
        if (this.scriptGen != null) {
            this.scriptGen.setProduct(this.product);
            this.scriptGen.setWorkDirPath(this.workDir.getPath());
            this.scriptGen.start(stringArray, testDescription, testEnvironment);
        }
    }

    protected void finish(String[] stringArray, TestDescription testDescription, TestEnvironment testEnvironment) {
        if (this.scriptGen != null) {
            this.scriptGen.finish(stringArray, testDescription, testEnvironment);
        }
    }

    public void setScriptGenMode(boolean bl) {
        this.scriptGen = bl ? new ScriptGen() : null;
    }

    public boolean isScriptGenMode() {
        return this.scriptGen != null;
    }

    public void setProduct(int n) {
        this.product = n;
    }

    public int getProduct() {
        return this.product;
    }

    protected Status invokeCommand(String string) {
        if (this.scriptGen == null) {
            return super.invokeCommand(string);
        }
        Status status = this.scriptGen.invokeCommand(string);
        if (this.scriptGen.runJTScript()) {
            super.invokeCommand(string);
        }
        return status;
    }

    protected boolean mkdirs(File file) {
        if (this.scriptGen == null) {
            return this.do_mkdirs(file);
        }
        return this.scriptGen.mkdirs(file);
    }

    private boolean do_mkdirs(File file) {
        if (file.exists()) {
            return file.isDirectory();
        }
        File file2 = file.isAbsolute() ? file : file.getAbsoluteFile();
        File file3 = file2.getParentFile();
        if (!this.do_mkdirs(file3)) {
            return false;
        }
        return file2.mkdir() || file2.isDirectory();
    }

    protected String filesInDir(File file, String string, String string2, boolean bl) {
        if (this.scriptGen != null) {
            return this.scriptGen.filesInDir(file, string, string2, bl);
        }
        return null;
    }

    protected boolean lockExecution(String[] stringArray) throws InterruptedException {
        return stringArray.length == 0 || lockTable.acquire(stringArray, Integer.MAX_VALUE);
    }

    protected void unlockExecution(String[] stringArray) {
        if (stringArray.length > 0) {
            lockTable.release(stringArray);
        }
    }

    public void run() {
        String[] stringArray = IntermediateScript.removeDuplicates(StringArray.split(this.td.getParameter("executeLocks")));
        try {
            boolean bl = this.lockExecution(stringArray);
            if (!bl) {
                throw new IllegalStateException("timeout waiting to acquire internal locks on: " + StringArray.join(stringArray));
            }
            super.run();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("interuppt waiting to acquire internal locks on: " + StringArray.join(stringArray));
        }
        finally {
            this.unlockExecution(stringArray);
        }
    }

    public void initTestDescription(TestDescription testDescription) {
        super.initTestDescription(testDescription);
        this.getTestResult().addObserver(new TimeAdjustTestResultObserver());
    }

    public static String[] removeDuplicates(String[] stringArray) {
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
        return hashSet.toArray(new String[0]);
    }

    class TimeAdjustTestResultObserver
    implements TestResult.Observer {
        TimeAdjustTestResultObserver() {
        }

        public void createdSection(TestResult testResult, TestResult.Section section) {
        }

        public void completedSection(TestResult testResult, TestResult.Section section) {
        }

        public void createdOutput(TestResult testResult, TestResult.Section section, String string) {
        }

        public void completedOutput(TestResult testResult, TestResult.Section section, String string) {
        }

        public void updatedOutput(TestResult testResult, TestResult.Section section, String string, int n, int n2, String string2) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updatedProperty(TestResult testResult, String string, String string2) {
            if ("start".equals(string) || "end".equals(string)) {
                testResult.removeObserver(this);
                try {
                    testResult.putProperty(string, TestResult.formatDate(new Date()));
                }
                finally {
                    testResult.addObserver(this);
                }
            }
        }

        public void completed(TestResult testResult) {
        }
    }

    public static class SkipTestException
    extends RuntimeException {
        private Status status;

        public SkipTestException(Status status) {
            this.setStatus(status);
        }

        public Status getStatus() {
            return this.status;
        }

        public void setStatus(Status status) {
            this.status = status;
        }
    }
}

