/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.lib;

import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestFinder;
import com.sun.javatest.finder.HTMLTestFinder;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.StringArray;
import com.sun.jck.lib.JCKTestSuite;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JCKTestFinder
extends HTMLTestFinder {
    private boolean verify;
    private String[] requiredEntries = JCKTestSuite.getRequiredEntries();
    private Map validEntries = JCKTestFinder.initTable(JCKTestSuite.getValidEntries());
    private Map validKeywords = JCKTestFinder.initTable(JCKTestSuite.getValidKeywords());
    private static final String TESTSUITE_HTML = "testsuite.html";
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(JCKTestFinder.class);
    public static final String PROPERTY_SKIPLIST = "jck.testfinder.skiplist";
    private List<File> skiplist;

    public void init(String[] stringArray, File file, TestEnvironment testEnvironment) throws TestFinder.Fault {
        this.setMode(2);
        this.decodeAllArgs(stringArray);
        this.setRoot(file);
        this.initSkipList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initSkipList() {
        BufferedReader bufferedReader = null;
        this.skiplist = new ArrayList<File>();
        try {
            String string;
            Properties properties = System.getProperties();
            String string2 = properties.getProperty(PROPERTY_SKIPLIST);
            if (string2 == null || string2.length() == 0) {
                return;
            }
            File file = new File(string2);
            bufferedReader = new LineNumberReader(new FileReader(file));
            while ((string = ((LineNumberReader)bufferedReader).readLine()) != null) {
                File file2;
                if (string.startsWith("#") || !(file2 = new File(this.getRoot(), string)).exists()) continue;
                this.skiplist.add(file2);
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(JCKTestFinder.class.getName()).log(Level.SEVERE, null, iOException);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                Logger.getLogger(JCKTestFinder.class.getName()).log(Level.SEVERE, null, iOException);
            }
        }
    }

    protected boolean isSkipped(File file) {
        if (this.skiplist == null || this.skiplist.isEmpty()) {
            return false;
        }
        if (file.isDirectory()) {
            return false;
        }
        return this.skiplist.contains(file);
    }

    public void setVerify(boolean bl) {
        this.verify = bl;
    }

    public void setRoot(File file) throws TestFinder.Fault {
        int n = this.getMode();
        if (file.isDirectory()) {
            File file2 = new File(file, TESTSUITE_HTML);
            if (!file2.exists() || file2.isDirectory() || !file2.canRead()) {
                throw new TestFinder.Fault(i18n, "jckFinder.badRootDir", new Object[]{TESTSUITE_HTML, file.getPath()});
            }
            if (n == 1) {
                file = file2;
            }
        } else {
            String string = file.getName();
            if (!string.equals(TESTSUITE_HTML)) {
                throw new TestFinder.Fault(i18n, "jckFinder.badRootFile");
            }
            if (n == 2) {
                file = new File(file.getParent());
            }
        }
        super.setRoot(file);
    }

    protected int decodeArg(String[] stringArray, int n) throws TestFinder.Fault {
        if (stringArray[n].equals("-verify")) {
            this.verify = true;
            return 1;
        }
        if (stringArray[n].equals("-allowEntry")) {
            String string = stringArray[n + 1];
            this.validEntries.put(string.toLowerCase(), string);
            return 2;
        }
        if (stringArray[n].equals("-allowKeyword")) {
            String string = stringArray[n + 1];
            this.validKeywords.put(string.toLowerCase(), string);
            return 2;
        }
        return super.decodeArg(stringArray, n);
    }

    protected void processEntry(Map map, String string, String string2) {
        Object object;
        boolean bl;
        boolean bl2 = bl = this.validEntries.get(string.toLowerCase()) != null;
        if (this.verify) {
            if (!bl) {
                this.error(i18n, "jckFinder.unknownEntry", new Object[]{string, this.getCurrentFile()});
            }
            if (string.equalsIgnoreCase("keywords")) {
                object = StringArray.split(string2);
                boolean bl3 = false;
                boolean bl4 = false;
                if (object != null) {
                    for (int i = 0; i < ((String[])object).length; ++i) {
                        String string3 = object[i];
                        if (this.validKeywords.get(string3.toLowerCase()) == null) {
                            this.error(i18n, "jckFinder.unknownKeyword", new Object[]{string3, this.getCurrentFile()});
                        }
                        if (string3.equals("runtime")) {
                            bl3 = true;
                            continue;
                        }
                        if (!string3.equals("compiler")) continue;
                        bl4 = true;
                    }
                }
                if (!bl3 && !bl4) {
                    this.error(i18n, "jckFinder.needCompOrRuntimeKeyword", this.getCurrentFile());
                }
            }
        }
        if (bl) {
            if ((string.equalsIgnoreCase("remote") || string.equalsIgnoreCase("jplisAgent")) && (object = (String)map.get(string)) != null) {
                string2 = (String)object + "\n" + string2.trim();
            }
            super.processEntry(map, string, string2);
        }
    }

    protected Map normalize(Map map) {
        if (this.verify) {
            for (int i = 0; i < this.requiredEntries.length; ++i) {
                if (map.get(this.requiredEntries[i]) != null) continue;
                this.error(i18n, "jckFinder.requiredEntryNotFound", new Object[]{this.requiredEntries[i], this.getCurrentFile()});
            }
        }
        return map;
    }

    private static Map initTable(String[] stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < stringArray.length; ++i) {
            hashMap.put(stringArray[i].toLowerCase(), stringArray[i]);
        }
        return hashMap;
    }

    protected void scan(File file) {
        if (this.isSkipped(file)) {
            return;
        }
        super.scan(file);
    }
}

