/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.lib;

import com.sun.jck.lib.Arguments;
import com.sun.jck.lib.Invoker;
import com.sun.jck.lib.SchemaCompilerTool;
import java.io.PrintStream;

public class SchemaCompilerInvoker
extends Invoker {
    protected String schemaCompilerClassName = null;
    private Arguments xsdFiles = new Arguments();
    private String packageName = null;
    private boolean isNotStrictValidation = false;

    public static void main(String[] stringArray) {
        int n;
        if (stringArray == null || stringArray.length == 0) {
            System.out.println("Usage:");
            System.out.println("\tjava com.sun.jck.lib.SchemaCompilerInvoker -xjc <className> - [-nv] -d <path> -p <package> <schema files..>");
            System.out.println("\tOptions:");
            System.out.println("\t-xjc <className> : specifies the class name that implements the SchemaCompilerTool interface");
            System.out.println("\t                   There is com.sun.jck.lib.SchemaCompiler that is fully compatible");
            System.out.println("\t                   with Sun's reference implementation ");
            System.out.println("\t-nv              : do not perform strict validation of the input schema(s)");
            System.out.println("\t-d <path>        : generated files will go into this directory");
            System.out.println("\t-p <package>     : specifies the target package");
            System.out.println("\t<schema files..>    : specifies the list of a schema files");
            System.exit(1);
        }
        try {
            n = new SchemaCompilerInvoker(stringArray).execute(System.out, System.err);
        }
        catch (Invoker.ArgumentException argumentException) {
            n = -1;
        }
        catch (Invoker.InvokeException invokeException) {
            invokeException.printStackTrace(System.err);
            n = -1;
        }
        System.exit(n);
    }

    public void processArguments() throws Invoker.ArgumentException {
        this.schemaCompilerClassName = this.args.getValue("-xjc");
        if (this.schemaCompilerClassName == null) {
            throw new Invoker.ArgumentException("The schema compiler invoker failed due to no class name specified after the -xjc option.");
        }
        this.args.removeArgs("-xjc", 2);
        this.isNotStrictValidation = this.args.contains("-nv");
        this.args.removeArgs("-nv", 1);
        this.args.setArgs(this.args.getTail("-", false));
        super.processArguments();
        this.args.removeArgs("-d", 2);
        this.packageName = this.args.getValue("-p");
        if (this.packageName == null) {
            throw new Invoker.ArgumentException("The schema compiler invoker failed due to no target package specified after the -p option.");
        }
        this.args.removeArgs("-p", 2);
        int n = this.args.size();
        if (n == 0) {
            throw new Invoker.ArgumentException("The schema compiler invoker failed due to No schema file(s) specified.");
        }
        for (int i = 0; i < n; ++i) {
            this.xsdFiles.append(this.args.get(i).split("\u0085"));
        }
    }

    public int invoke(PrintStream printStream, PrintStream printStream2) throws Invoker.InvokeException {
        try {
            String[] stringArray;
            Class<?> clazz = Class.forName(this.schemaCompilerClassName);
            SchemaCompilerTool schemaCompilerTool = (SchemaCompilerTool)SchemaCompilerTool.class.cast(clazz.newInstance());
            String[] stringArray2 = this.xsdFiles.getArgs();
            if (this.isNotStrictValidation) {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = "-nv";
            } else {
                stringArray = null;
            }
            Integer n = schemaCompilerTool.compile(stringArray2, this.packageName, this.outDir, stringArray, printStream, printStream2);
            if (n instanceof Integer) {
                int n2 = n;
                return n2 == 0 ? 0 : -1;
            }
            throw new Invoker.InvokeException("Unexpected return value from a schema compiler: " + n);
        }
        catch (Exception exception) {
            exception.printStackTrace(printStream2);
            String string = exception.getMessage();
            throw new Invoker.InvokeException("The schema compiler invoker failed " + (string != null ? "with the message '" + string + "'" : ""));
        }
    }

    public SchemaCompilerInvoker(String[] stringArray) {
        super(stringArray);
    }

    public SchemaCompilerInvoker(Arguments arguments) {
        super(arguments);
    }
}

