/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.lib;

import com.sun.javatest.Status;
import com.sun.jck.lib.CompilerAPICommand;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.tools.JavaCompiler;
import javax.tools.StandardJavaFileManager;

public class SharedCompilerAPICmd
extends CompilerAPICommand {
    private int threshold = -1;
    private static Map<Class, HashEntry> compilers = Collections.synchronizedMap(new HashMap());

    public Status run(String[] stringArray, PrintWriter printWriter, PrintWriter printWriter2) {
        try {
            this.decodeAllArgs(stringArray);
            if (this.outDir != null) {
                new File(this.outDir).mkdirs();
            }
            return this.doCompile(printWriter2) ? COMPILATION_PASSED : COMPILATION_FAILED;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(printWriter2);
            return Status.error(throwable.toString());
        }
    }

    protected boolean doCompile(PrintWriter printWriter) throws IOException {
        boolean bl = false;
        JavaCompiler javaCompiler = this.getCompiler();
        HashEntry hashEntry = compilers.get(javaCompiler.getClass());
        if (hashEntry == null) {
            StandardJavaFileManager standardJavaFileManager = javaCompiler.getStandardFileManager(null, null, null);
            hashEntry = new HashEntry(javaCompiler, standardJavaFileManager);
            compilers.put(javaCompiler.getClass(), hashEntry);
        }
        bl = this.doCompile(hashEntry.compiler, hashEntry.manager, printWriter);
        this.count(hashEntry);
        return bl;
    }

    protected int decodeArg(String[] stringArray, int n) {
        if (stringArray[n].equals("-Xthreshold") && n + 1 < stringArray.length) {
            this.threshold = Integer.valueOf(stringArray[n + 1]);
            return 2;
        }
        return super.decodeArg(stringArray, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void count(HashEntry hashEntry) throws IOException {
        if (this.threshold != -1 && hashEntry.counter++ >= this.threshold) {
            try {
                hashEntry.manager.close();
            }
            finally {
                compilers.remove(hashEntry.compiler.getClass());
            }
        }
    }

    private static class HashEntry {
        JavaCompiler compiler;
        StandardJavaFileManager manager;
        int counter = 0;

        HashEntry(JavaCompiler javaCompiler, StandardJavaFileManager standardJavaFileManager) {
            this.compiler = javaCompiler;
            this.manager = standardJavaFileManager;
        }

        public String toString() {
            return "compiler=" + this.compiler.getClass() + "," + "manager=" + this.manager.toString() + "," + "counter=" + this.counter;
        }
    }
}

