/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.lib.extracttest;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.util.Arrays;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class Main {
    private static final String TEST_DEPS_REL_PATH = "src" + File.separator + "share" + File.separator + "testdeps" + File.separator + "testdep.properties";
    private static final String LIB_DEPS_REL_PATH = "src" + File.separator + "share" + File.separator + "testdeps" + File.separator + "libdep.properties";
    private static final String DEP_DELIM = ":";
    private static final String PREFIX_LIB = "lib.id";
    private String testURL = null;
    private String tckRoot = null;
    private String outDir = null;
    private boolean isHelpNeeded = false;
    private boolean isVerboseMode = false;
    private Properties testDeps = null;
    private Properties libDeps = null;

    public static void main(String[] stringArray) {
        Main main = new Main();
        try {
            main.init(stringArray);
            main.run();
        }
        catch (NeedHelpException needHelpException) {
            main.printHelp(System.out);
        }
        catch (InitException initException) {
            System.err.println();
            System.err.println(initException.getMessage());
            System.exit(1);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println();
            System.err.println(fileNotFoundException);
            System.err.println("Due to the internal error this test can not be extracted. Please report an error to Sun representatives and include the URL of the test: " + main.testURL);
            System.exit(1);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            System.exit(1);
        }
    }

    protected void printHelp(PrintStream printStream) {
        printStream.println();
        printStream.println("Test Extractor Tool");
        printStream.println();
        printStream.println("Use this tool to extract the sources of a single test from the TCK.");
        printStream.println("For more information please address the JCK User's Guide.");
        printStream.println();
        printStream.println("Usage: java com.sun.jck.lib.extracttest.Main [options] testURL");
        printStream.println("where options are:");
        printStream.println("  -tckRoot <path>         Path to the TCK root to extract the pointed test from (default - current)");
        printStream.println("  -o <path>               Path to the directory for output (default - current)");
        printStream.println();
    }

    protected void init(String[] stringArray) throws InitException, NeedHelpException {
        File file;
        this.checkJavaVersionIsNotLessThan6();
        try {
            this.decodeAllArgs(stringArray);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new NeedHelpException();
        }
        if (this.isHelpNeeded) {
            throw new NeedHelpException();
        }
        if (this.testURL == null) {
            throw new InitException("Please specify testURL");
        }
        if (this.outDir == null) {
            if (this.tckRoot == null) {
                throw new InitException("The default values of TCK root path and output directory path are equal. It is not recommended to use the TCK root path for output. You can force such behavior by explicitly specifying paths via -tckRoot and -o options.");
            }
            this.outDir = System.getProperties().getProperty("user.dir");
        }
        if (!this.pathExists(this.outDir) && !(file = new File(this.outDir)).mkdirs()) {
            throw new InitException("Unable to create the output directory: " + this.outDir);
        }
        if (this.tckRoot == null) {
            this.tckRoot = System.getProperties().getProperty("user.dir");
        }
        if (!this.pathExists(this.tckRoot + File.separator + TEST_DEPS_REL_PATH)) {
            throw new InitException("File " + TEST_DEPS_REL_PATH + " does not " + "exist. Please provide a valid path to the TCK root.");
        }
        if (!this.pathExists(this.tckRoot + File.separator + LIB_DEPS_REL_PATH)) {
            throw new InitException("File " + LIB_DEPS_REL_PATH + " does not " + "exist. Please provide a valid path to the TCK root.");
        }
    }

    private void decodeAllArgs(String[] stringArray) throws InitException {
        if (stringArray.length == 0) {
            this.isHelpNeeded = true;
        } else {
            int n;
            for (int i = 0; i < stringArray.length; i += n) {
                n = this.decodeArg(stringArray, i);
                if (n != 0) continue;
                throw new InitException("Could not recognize argument: " + stringArray[i]);
            }
        }
    }

    protected int decodeArg(String[] stringArray, int n) {
        String string = stringArray[n];
        if (string.equalsIgnoreCase("-help") || string.equalsIgnoreCase("-h") || string.equalsIgnoreCase("--help")) {
            this.isHelpNeeded = true;
            return 1;
        }
        if (string.equalsIgnoreCase("-o")) {
            this.outDir = stringArray[n + 1];
            return 2;
        }
        if (string.equalsIgnoreCase("-tckRoot")) {
            this.tckRoot = stringArray[n + 1];
            return 2;
        }
        if (string.equalsIgnoreCase("-verbose")) {
            this.isVerboseMode = true;
            return 1;
        }
        if (n == stringArray.length - 1) {
            this.testURL = string;
            return 1;
        }
        return 0;
    }

    private void checkJavaVersionIsNotLessThan6() throws InitException {
        try {
            Properties.class.getMethod("load", Reader.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new InitException("Use Java SE 6.0 or later to run the Test Extractor tool.");
        }
    }

    protected void run() throws FileNotFoundException, IOException, InitException {
        String string = this.getTestDependencyString(this.testURL);
        this.extractFiles(string, false);
    }

    private void extractFiles(String string, boolean bl) throws FileNotFoundException, IOException, InitException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, DEP_DELIM);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (this.isLibID(string2)) {
                if (bl) continue;
                this.extractFiles(this.getLibDependencyString(string2), true);
                continue;
            }
            if (this.isVerboseMode) {
                System.out.println("Copying from: " + this.tckRoot + File.separator + string2 + " to: " + this.outDir + File.separator + this.getFileDestination(string2));
            }
            this.copyFile(this.tckRoot + File.separator + string2, this.outDir + File.separator + this.getFileDestination(string2));
        }
    }

    private String getTestDependencyString(String string) throws FileNotFoundException, InitException, IOException {
        Object object;
        if (this.testDeps == null) {
            object = new File(this.tckRoot, TEST_DEPS_REL_PATH);
            this.testDeps = new Properties();
            this.testDeps.load(new FileReader((File)object));
            if (this.isVerboseMode) {
                System.out.println("Loaded " + object);
            }
            String[] stringArray = ((File)object).getParentFile().list(new FilenameFilter((File)object){
                final /* synthetic */ File val$testDepsFullName;
                {
                    this.val$testDepsFullName = file;
                }

                public boolean accept(File file, String string) {
                    if (new File(file, string).isFile()) {
                        return Pattern.matches(this.val$testDepsFullName.getName().replaceAll("\\.", "\\\\.") + "\\.\\d+", string);
                    }
                    return false;
                }
            });
            Arrays.sort(stringArray, null);
            for (String string2 : stringArray) {
                File file = new File(((File)object).getParent(), string2);
                this.testDeps.load(new FileReader(file));
                if (!this.isVerboseMode) continue;
                System.out.println("Loaded " + file);
            }
        }
        if ((object = this.testDeps.getProperty(string)) == null) {
            throw new InitException("The specified testURL (" + string + ") is not found in the product (" + this.tckRoot + ")");
        }
        return object;
    }

    private String getLibDependencyString(String string) throws FileNotFoundException, IOException, InitException {
        Object object;
        if (this.libDeps == null) {
            object = new File(this.tckRoot, LIB_DEPS_REL_PATH);
            this.libDeps = new Properties();
            this.libDeps.load(new FileReader((File)object));
            if (this.isVerboseMode) {
                System.out.println("Loaded " + object);
            }
            String[] stringArray = ((File)object).getParentFile().list(new FilenameFilter((File)object){
                final /* synthetic */ File val$libDepsFullName;
                {
                    this.val$libDepsFullName = file;
                }

                public boolean accept(File file, String string) {
                    if (new File(file, string).isFile()) {
                        return Pattern.matches(this.val$libDepsFullName.getName().replaceAll("\\.", "\\\\.") + "\\.\\d+", string);
                    }
                    return false;
                }
            });
            Arrays.sort(stringArray, null);
            for (String string2 : stringArray) {
                File file = new File(((File)object).getParent(), string2);
                this.libDeps.load(new FileReader(file));
                if (!this.isVerboseMode) continue;
                System.out.println("Loaded " + file);
            }
        }
        if ((object = this.libDeps.getProperty(string)) == null) {
            throw new InitException("An error occured: the specified library identifier was not found in the dependencies knowledge base: " + string);
        }
        return object;
    }

    private String getFileDestination(String string) {
        return string;
    }

    private void copyFile(String string, String string2) throws FileNotFoundException, IOException {
        int n;
        File file = new File(string2).getParentFile();
        if (!file.exists()) {
            file.mkdirs();
        }
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        FileOutputStream fileOutputStream = new FileOutputStream(new File(string2));
        byte[] byArray = new byte[1024];
        while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
            ((OutputStream)fileOutputStream).write(byArray, 0, n);
        }
        ((InputStream)fileInputStream).close();
        fileOutputStream.flush();
        ((OutputStream)fileOutputStream).close();
    }

    private boolean isLibID(String string) {
        return string.startsWith(PREFIX_LIB);
    }

    private boolean pathExists(String string) {
        File file = new File(string);
        return file.exists();
    }

    public static class NeedHelpException
    extends Exception {
    }

    public static class InitException
    extends Exception {
        public InitException(String string) {
            super(string);
        }
    }
}

