/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.lib.runner;

import com.sun.javatest.DefaultTestRunner;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestResult;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCKTestRunner
extends DefaultTestRunner
implements Iterator {
    public static String USE_DEFAULT = "jck.concurrency.useDefaultTestRunner";
    private static final int SLOW_TESTS_MIN_CONCURRENCY = 4;
    private static final String SLOW_TESTS_PROPERTY = "jck.concurrency.slowtests";
    private static final String SLOW_TESTS_PATTERN_FILE = "slowtestspatterns.txt";
    private static final String LOG_PROPERTY = "jck.concurrency.log.JCKTestRunner";
    private Iterator<TestDescription> testIter;
    private Map<String, AtomicInteger> runningLocksMap = new HashMap<String, AtomicInteger>();
    private LinkedHashMap<TestDescription, List<String>> testsWithLocks = new LinkedHashMap();
    private LinkedList<TestDescription> slowTests = new LinkedList();
    private List<String> slowTestsPatterns = new ArrayList<String>();
    private boolean isSlowTestsMode = false;
    private int maxSlowRunning = 0;
    private volatile int currentSlowRunning = 0;
    private Logger log = Logger.getLogger(this.getClass().getName());

    public JCKTestRunner(int n) {
        if (System.getProperty(LOG_PROPERTY) != null) {
            this.log.setLevel(Level.INFO);
        } else {
            this.log.setLevel(Level.OFF);
        }
        this.maxSlowRunning = Integer.getInteger(SLOW_TESTS_PROPERTY, n / 4);
        boolean bl = this.isSlowTestsMode = this.maxSlowRunning >= 1;
        if (this.isSlowTestsMode) {
            this.readSlowTestsPatterns();
            if (this.slowTestsPatterns.isEmpty()) {
                this.isSlowTestsMode = false;
                this.log.info("No slow tests patterns were found! Optimization for running slow tests is off!");
            } else {
                this.log.info("Slow tests patterns:" + this.slowTestsPatterns);
            }
        } else {
            this.log.info("Optimization for running slow tests is off");
        }
        this.log.info("Using JCKTestRunner with slow mode:" + this.isSlowTestsMode + ", concurrency:" + n);
    }

    @Override
    public synchronized boolean runTests(Iterator iterator) throws InterruptedException {
        this.testIter = iterator;
        return super.runTests(this);
    }

    @Override
    public synchronized boolean hasNext() {
        return this.testIter.hasNext() || !this.testsWithLocks.isEmpty() || this.isSlowTestsMode && !this.slowTests.isEmpty();
    }

    public synchronized Object next() {
        TestDescription testDescription;
        TestDescription testDescription2 = this.getTestFromLocksQueue();
        if (testDescription2 != null) {
            this.addRunningLocks(testDescription2);
            this.printLocks();
            return testDescription2;
        }
        if (this.isSlowTestsMode && this.currentSlowRunning < this.maxSlowRunning && !this.slowTests.isEmpty()) {
            ++this.currentSlowRunning;
            this.log.info("Slow test started, first from queue : " + this.slowTests.getFirst().getRootRelativeURL());
            this.log.info("Slow queue size:" + this.slowTests.size());
            this.log.info("Currently running slow tests:" + this.currentSlowRunning);
            return this.slowTests.removeFirst();
        }
        while (this.testIter.hasNext()) {
            testDescription = this.testIter.next();
            if (JCKTestRunner.getLocksList(testDescription) != null) {
                if (this.checkLocks(testDescription) == null) continue;
                this.addRunningLocks(testDescription);
                return testDescription;
            }
            if (this.isSlowTestsMode && this.matchesSlowTestPattern(testDescription)) {
                TestDescription testDescription3 = this.getFromSlowQueue(testDescription);
                if (testDescription3 != null) {
                    ++this.currentSlowRunning;
                    this.log.info("Slow test started: " + testDescription.getRootRelativeURL());
                    this.log.info("Currently running slow tests:" + this.currentSlowRunning);
                    return testDescription;
                }
                this.log.info("Slow test placed into queue: " + testDescription.getRootRelativeURL());
                this.log.info("Slow queue size:" + this.slowTests.size());
                continue;
            }
            return testDescription;
        }
        if (this.isSlowTestsMode && !this.slowTests.isEmpty()) {
            ++this.currentSlowRunning;
            return this.slowTests.removeFirst();
        }
        testDescription = this.getFirstFromLocksQueue();
        if (testDescription != null) {
            this.addRunningLocks(testDescription);
        }
        return testDescription;
    }

    private TestDescription getFirstFromLocksQueue() {
        if (!this.testsWithLocks.isEmpty()) {
            TestDescription testDescription = this.testsWithLocks.entrySet().iterator().next().getKey();
            this.testsWithLocks.remove(testDescription);
            this.log.info("Lock report: first element removed fromqueue : " + testDescription.getRootRelativeURL());
            return testDescription;
        }
        return null;
    }

    private TestDescription getTestFromLocksQueue() {
        for (Map.Entry<TestDescription, List<String>> entry : this.testsWithLocks.entrySet()) {
            if (this.containsRunningLocks(entry.getValue())) continue;
            TestDescription testDescription = entry.getKey();
            this.log.info("Lock report: element removed from queue: " + testDescription.getRootRelativeURL() + " , since lock is free: " + entry.getValue());
            this.testsWithLocks.remove(testDescription);
            return testDescription;
        }
        return null;
    }

    private TestDescription checkLocks(TestDescription testDescription) {
        List<String> list = JCKTestRunner.getLocksList(testDescription);
        if (!this.containsRunningLocks(list)) {
            return testDescription;
        }
        this.testsWithLocks.put(testDescription, list);
        this.log.info("Lock report: added to queue: " + testDescription.getRootRelativeURL() + " , with locks: " + list);
        return null;
    }

    private TestDescription getFromSlowQueue(TestDescription testDescription) {
        if (this.currentSlowRunning >= this.maxSlowRunning) {
            this.slowTests.add(testDescription);
            return null;
        }
        TestDescription testDescription2 = null;
        if (this.slowTests.isEmpty()) {
            testDescription2 = testDescription;
        } else {
            this.slowTests.add(testDescription);
            testDescription2 = this.slowTests.removeFirst();
        }
        return testDescription2;
    }

    @Override
    protected synchronized void notifyFinishedTest(TestResult testResult) {
        List<String> list = JCKTestRunner.getLocksList(testResult);
        if (list != null) {
            for (String string : list) {
                if (this.runningLocksMap.get(string).decrementAndGet() == 0) {
                    this.runningLocksMap.remove(string);
                    this.log.info("---Lock report: lock removed '" + string + "', test finished:" + testResult.getTestName());
                    continue;
                }
                this.log.info("---Lock report: lock decremented '" + string + "', test finished:" + testResult.getTestName());
            }
        } else if (this.isSlowTestsMode && this.isMatchesSlowTestPattern(testResult)) {
            --this.currentSlowRunning;
            this.log.info("Running slow tests decremented to :" + this.currentSlowRunning + ", test finishing:" + testResult.getTestName());
        }
        super.notifyFinishedTest(testResult);
    }

    private void addRunningLocks(TestDescription testDescription) {
        List<String> list = JCKTestRunner.getLocksList(testDescription);
        for (String string : list) {
            AtomicInteger atomicInteger = this.runningLocksMap.get(string);
            if (atomicInteger == null) {
                this.runningLocksMap.put(string, new AtomicInteger(1));
                this.log.info("---Lock report: lock added '" + string + "' for test:" + testDescription.getRootRelativeURL());
                continue;
            }
            atomicInteger.incrementAndGet();
            this.log.info("---Lock report: lock incremented '" + string + "' for test:" + testDescription.getRootRelativeURL());
        }
    }

    private boolean containsRunningLocks(List<String> list) {
        for (String string : list) {
            if (!this.runningLocksMap.containsKey(string)) continue;
            return true;
        }
        return false;
    }

    private void printLocks() {
        this.log.info("---Lock report:---");
        this.log.info("running locks number:" + this.runningLocksMap.size());
        this.log.info("running locks:" + this.runningLocksMap);
        this.log.info("Number of elements in LocksQueue:" + this.testsWithLocks.size());
        this.log.info("---Lock report finished---");
    }

    public static List<String> getLocksList(TestDescription testDescription) {
        String string = testDescription.getParameter("executeLocks");
        if (string == null) {
            return null;
        }
        return Arrays.asList(string.split("\\s+"));
    }

    public static List<String> getLocksList(TestResult testResult) {
        TestDescription testDescription;
        try {
            testDescription = testResult.getDescription();
        }
        catch (TestResult.Fault fault) {
            fault.printStackTrace();
            return null;
        }
        return JCKTestRunner.getLocksList(testDescription);
    }

    private boolean matchesSlowTestPattern(TestDescription testDescription) {
        String string = testDescription.getRootRelativeURL();
        for (String string2 : this.slowTestsPatterns) {
            if (!string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    private boolean isMatchesSlowTestPattern(TestResult testResult) {
        TestDescription testDescription;
        try {
            testDescription = testResult.getDescription();
        }
        catch (TestResult.Fault fault) {
            fault.printStackTrace();
            return false;
        }
        return this.matchesSlowTestPattern(testDescription);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSlowTestsPatterns() {
        InputStream inputStream = this.getClass().getResourceAsStream(SLOW_TESTS_PATTERN_FILE);
        if (inputStream != null) {
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    this.slowTestsPatterns.add(string);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

