/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.services;

import com.sun.javatest.services.Message;
import com.sun.javatest.services.ProcessParams;
import com.sun.javatest.services.Service;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;

public abstract class AbstractService
extends Service {
    String getInterviewProperty(String string) {
        Properties properties = this.props.getExternalProperties();
        return properties.getProperty(string);
    }

    float getTimeoutFactor() {
        String string = this.getInterviewProperty("javatestTimeoutFactor");
        float f = 1.0f;
        try {
            f = Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return f;
    }

    void logStartMessage(Message message) {
        ProcessParams processParams = (ProcessParams)message.getContent();
        List<String> list = processParams.getCommand();
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : list) {
            stringBuilder.append(string);
            stringBuilder.append(" ");
        }
        this.getLog().info("Starting: " + stringBuilder.toString());
    }

    void logMessageContent(Message message) {
        Serializable serializable = message.getContent();
        if (serializable == null || !(serializable instanceof String)) {
            return;
        }
        String string = (String)((Object)serializable);
        if (string.length() == 0) {
            return;
        }
        if (this.getLog() == null) {
            return;
        }
        this.getLog().info(string);
    }

    public boolean start() throws Service.NotConnectedException, Service.ServiceError {
        Message message;
        if (this.conn == null || !this.conn.connected()) {
            throw new Service.NotConnectedException("Not connected to executor");
        }
        try {
            message = this.prepareMessage(Message.MessageType.START);
        }
        catch (Service.MalformedParamsException malformedParamsException) {
            this.logMalformedException(malformedParamsException, Message.MessageType.START);
            return false;
        }
        Message message2 = this.conn.send(message);
        this.logMessageContent(message2);
        if (message2.getType() == Message.MessageType.ERROR) {
            throw new Service.ServiceError(message2.getContent().toString());
        }
        if (message2.getType() != Message.MessageType.STARTED) {
            this.logBadMsgTypeException(message2.getType(), Message.MessageType.STARTED);
            return false;
        }
        return true;
    }

    public boolean stop() throws Service.NotConnectedException, Service.ServiceError {
        Message message;
        if (this.conn == null || !this.conn.connected()) {
            throw new Service.NotConnectedException("Not connected to executor");
        }
        try {
            message = this.prepareMessage(Message.MessageType.STOP);
        }
        catch (Service.MalformedParamsException malformedParamsException) {
            this.logMalformedException(malformedParamsException, Message.MessageType.STOP);
            return false;
        }
        Message message2 = this.conn.send(message);
        this.logMessageContent(message2);
        if (message2.getType() == Message.MessageType.ERROR) {
            String string = "";
            try {
                string = message2.getContent().toString();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            throw new Service.ServiceError(string);
        }
        if (message2.getType() != Message.MessageType.STOPPED) {
            this.logBadMsgTypeException(message2.getType(), Message.MessageType.STOPPED);
            return false;
        }
        return true;
    }

    public boolean isAlive() throws Service.NotConnectedException, Service.ServiceError {
        Message message;
        if (this.conn == null || !this.conn.connected()) {
            throw new Service.NotConnectedException("Not connected to executor");
        }
        try {
            message = this.prepareMessage(Message.MessageType.IS_ALIVE);
        }
        catch (Service.MalformedParamsException malformedParamsException) {
            this.logMalformedException(malformedParamsException, Message.MessageType.IS_ALIVE);
            return false;
        }
        Message message2 = this.conn.send(message);
        this.logMessageContent(message2);
        if (message2.getType() == Message.MessageType.ERROR) {
            throw new Service.ServiceError(message2.getContent().toString());
        }
        if (message2.getType() != Message.MessageType.ALIVE && message2.getType() != Message.MessageType.NOT_ALIVE) {
            this.logBadMsgTypeException(message2.getType(), Message.MessageType.ALIVE);
            this.logBadMsgTypeException(message2.getType(), Message.MessageType.NOT_ALIVE);
            return false;
        }
        return message2.getType() == Message.MessageType.ALIVE;
    }

    private void logMalformedException(Service.MalformedParamsException malformedParamsException, Message.MessageType messageType) {
        String string = "Message malformed.\n";
        string = string + "Message type: " + messageType.toString() + "\n";
        Map<String, String> map = malformedParamsException.getParams();
        if (map != null) {
            string = string + "Parameters used:\n";
            for (String string2 : map.keySet()) {
                string = string + string2 + '=' + map.get(string2);
            }
        }
        this.log.log(Level.SEVERE, string);
    }

    private void logBadMsgTypeException(Message.MessageType messageType, Message.MessageType messageType2) {
        String string = "Wrong response msg type: \n";
        string = string + "Received :" + messageType.toString() + "\n";
        string = string + "Expected :" + messageType2.toString() + "\n";
        this.log.log(Level.SEVERE, string);
    }

    public boolean enabled() {
        return true;
    }
}

