/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.services;

import com.sun.javatest.services.Message;
import com.sun.javatest.services.ProcessParams;
import com.sun.javatest.services.Service;
import com.sun.jck.services.CommandBuilder;
import com.sun.jck.services.LocalCommandBuilder;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteCommandBuilder
extends CommandBuilder {
    private LocalCommandBuilder builder;
    private String host;

    public RemoteCommandBuilder(LocalCommandBuilder localCommandBuilder, String string) {
        this(localCommandBuilder);
        this.setHost(string);
    }

    public RemoteCommandBuilder(LocalCommandBuilder localCommandBuilder) {
        super(localCommandBuilder.getProps());
        this.builder = localCommandBuilder;
    }

    @Override
    public String getCommand() throws CommandBuilder.CommandBuilderException {
        if (this.isLocal()) {
            return this.builder.getCommand();
        }
        Properties properties = this.getProps().getExternalProperties();
        String string = properties.getProperty("ssh.command");
        String string2 = properties.getProperty("testsuite.root");
        super.setValue(string, null);
        super.setValue(this.host, "@{host}");
        super.setValue(this.builder.getCommand(), "@{command}");
        super.setValue(string2, "@{testsuite}");
        return super.getCommand();
    }

    @Override
    public void setProperty(String string, String string2) {
        this.builder.setProperty(string, string2);
    }

    @Override
    public void setValue(String string, String string2) {
        this.builder.setValue(string, string2);
    }

    @Override
    public List<String> constructCommand() throws CommandBuilder.CommandBuilderException {
        if (this.isLocal()) {
            return this.builder.constructCommand();
        }
        return super.constructCommand();
    }

    String getHost() {
        return this.host;
    }

    private boolean isLocal() throws CommandBuilder.CommandBuilderException {
        if (this.host == null) {
            return true;
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(this.host);
            if (inetAddress.isLoopbackAddress()) {
                return true;
            }
            InetAddress inetAddress2 = InetAddress.getLocalHost();
            return inetAddress2.equals(inetAddress);
        }
        catch (UnknownHostException unknownHostException) {
            throw (CommandBuilder)this.new CommandBuilder.CommandBuilderException("Unknown host: " + this.host);
        }
    }

    public Message getMessage() throws Service.MalformedParamsException {
        List<String> list;
        ProcessParams processParams = this.builder.createParams(this);
        try {
            list = this.constructCommand();
        }
        catch (CommandBuilder.CommandBuilderException commandBuilderException) {
            throw new Service.MalformedParamsException(commandBuilderException.getMessage(), null);
        }
        HashMap<String, String> hashMap = null;
        int n = -1;
        for (String string : list) {
            if (!string.contains("=")) break;
            int n2 = string.indexOf("=");
            String string2 = string.substring(0, n2);
            String string3 = "";
            if (n2 != string.length() - 1) {
                string3 = string.substring(n2 + 1);
            }
            if (hashMap == null) {
                hashMap = new HashMap<String, String>();
                processParams.setEnvironment(hashMap);
            }
            hashMap.put(string2, string3);
            ++n;
        }
        if (n > -1) {
            list = new ArrayList<String>(list);
        }
        for (int i = 0; i <= n; ++i) {
            list.remove(0);
        }
        processParams.setCommand(list);
        Message message = new Message(Message.MessageType.START, processParams);
        return message;
    }

    public void setHost(String string) {
        this.host = string;
    }
}

