/*
 * Decompiled with CFR 0.152.
 */
package javasoft.sqe.javatest.lib;

import com.sun.javatest.Script;
import com.sun.javatest.Status;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import java.io.File;

public class SimpTestScript
extends Script {
    private boolean executeSimple;
    private boolean useWrapper;

    public Status run(String[] args, TestDescription td, TestEnvironment env) {
        boolean expectFail = false;
        boolean compile = false;
        boolean compileIndividually = false;
        boolean execute = false;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-compile") || arg.equals("-compileTogether")) {
                compile = true;
                continue;
            }
            if (arg.equals("-compileIndividually")) {
                compileIndividually = true;
                compile = true;
                continue;
            }
            if (arg.equals("-execute")) {
                execute = true;
                continue;
            }
            if (arg.equals("-expectFail")) {
                expectFail = true;
                continue;
            }
            if (arg.equals("-useWrapper")) {
                this.useWrapper = true;
                continue;
            }
            if (arg.equals("-executeSimple")) {
                this.executeSimple = true;
                execute = true;
                continue;
            }
            return Status.failed("bad arg for script: `" + arg + "'");
        }
        if (compile) {
            File[] srcs = td.getSourceFiles();
            Status compileStatus = compileIndividually ? this.compileIndividually(srcs) : this.compileTogether(srcs);
            if (compileStatus.getType() == 0 && this.useWrapper) {
                String c = td.getParameter("executeClass");
                if (c == null) {
                    return Script.error_noExecuteClass;
                }
                int lastDot = c.lastIndexOf(46);
                String w = (lastDot == -1 ? c : c.substring(lastDot + 1)) + "t.java";
                File wf = new File(td.getDir(), w);
                compileStatus = this.compileOne(wf);
            }
            if (!execute) {
                if (expectFail) {
                    if (compileStatus.getType() == 1) {
                        return Script.pass_compFailExp.augment(compileStatus);
                    }
                    return Script.fail_compSuccUnexp.augment(compileStatus);
                }
                return compileStatus;
            }
            if (compileStatus.getType() == 1) {
                return Script.fail_compFailUnexp.augment(compileStatus);
            }
        }
        if (execute) {
            String executeClass = td.getParameter("executeClass");
            if (executeClass == null) {
                return Script.error_noExecuteClass;
            }
            if (this.useWrapper) {
                executeClass = executeClass + "t";
            }
            Status executeStatus = this.execute(executeClass, td.getParameter("executeArgs"));
            if (expectFail) {
                if (executeStatus.getType() == 1) {
                    return Script.pass_execFailExp.augment(executeStatus);
                }
                return Script.fail_execSuccUnexp.augment(executeStatus);
            }
            return executeStatus;
        }
        return Script.error_noActionSpecified;
    }

    protected Status execute(String executeClass, String[] executeArgs) {
        this.env.put("testExecuteClass", executeClass);
        this.env.put("testExecuteArgs", executeArgs);
        String key = this.executeSimple ? "executeSimple" : "execute";
        return this.invokeCommand(key);
    }
}

