/*
 * Decompiled with CFR 0.152.
 */
package javasoft.sqe.javatest.lib.apitest;

import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;
import javasoft.sqe.javatest.Status;
import javasoft.sqe.javatest.Test;
import javasoft.sqe.javatest.lib.apitest.Factory;
import javasoft.sqe.javatest.lib.apitest.Generator;
import javasoft.sqe.javatest.lib.apitest.GridGenerator;
import javasoft.sqe.javatest.lib.apitest.PrintReporter;
import javasoft.sqe.javatest.lib.apitest.Reporter;

public abstract class AssertionTest
implements Test {
    protected PrintWriter log;
    protected PrintWriter ref;
    protected Generator generator;
    protected String generatorClassName;
    protected String[] generatorArgs;
    protected String reporterClassName;
    protected String[] reporterArgs;
    protected Reporter reporter;
    private Object objectUnderTest;
    private Method methodUnderTest;
    private Constructor constructorUnderTest;
    private Object[] exeParameters;
    private int[] exeSignature;
    private Object result;
    private Factory[] dataFactories;
    private boolean canAssertionBeChecked;
    private boolean methodTest = true;
    private boolean didAssertionFail = false;
    private ExceptionSet expectedExceptionSet;

    public Status run(String[] stringArray, PrintWriter printWriter, PrintWriter printWriter2) {
        this.log = printWriter;
        this.ref = printWriter2;
        try {
            this.decodeAllArgs(stringArray);
            this.init();
        }
        catch (Fault fault) {
            return Status.failed(fault.getMessage());
        }
        if (this.methodTest) {
            this.reporter.reportTestStart(this.methodUnderTest, this.dataFactories);
        } else {
            this.reporter.reportTestStart(this.constructorUnderTest, this.dataFactories);
        }
        Status status = this.generator.run(this, this.dataFactories);
        this.reporter.reportTestDone(status);
        return status;
    }

    protected final void decodeAllArgs(String[] stringArray) throws Fault {
        int n;
        for (int i = 0; i < stringArray.length; i += n) {
            n = this.decodeArg(stringArray, i);
            if (n != 0) continue;
            throw new Fault("Argument Unrecognized: " + stringArray[i]);
        }
    }

    protected void init() throws Fault {
        try {
            this.createReporter(this.reporterClassName);
            this.createGenerator(this.generatorClassName);
        }
        catch (Fault fault) {
            throw new Fault(fault.getMessage());
        }
    }

    protected int decodeArg(String[] stringArray, int n) throws Fault {
        int n2 = n;
        if (stringArray[n2].equals("-generator")) {
            Vector<String> vector = new Vector<String>();
            this.generatorClassName = stringArray[++n2];
            try {
                while (!stringArray[++n2].equals("-end")) {
                    vector.addElement(stringArray[n2]);
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new Fault("There is no -end to the generator parameter list");
            }
            ++n2;
            this.generatorArgs = new String[vector.size()];
            vector.copyInto(this.generatorArgs);
        } else if (stringArray[n2].equals("-reporter")) {
            Vector<String> vector = new Vector<String>();
            this.reporterClassName = stringArray[++n2];
            try {
                while (!stringArray[++n2].equals("-end")) {
                    vector.addElement(stringArray[n2]);
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new Fault("There is no -end to the reporter parameter list");
            }
            ++n2;
            this.reporterArgs = new String[vector.size()];
            vector.copyInto(this.reporterArgs);
        } else {
            return 0;
        }
        return n2 - n;
    }

    private void createGenerator(String string) throws Fault {
        if (string != null) {
            try {
                Class<?> clazz = Class.forName(string);
                if (!Generator.class.isAssignableFrom(clazz)) {
                    throw new Fault("This is not a valid generator class");
                }
                this.generator = (Generator)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new Fault(classNotFoundException.toString());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new Fault(illegalAccessException.toString());
            }
            catch (InstantiationException instantiationException) {
                throw new Fault(instantiationException.toString());
            }
        } else {
            this.generator = new GridGenerator();
        }
        this.generator.init(this.generatorArgs);
    }

    private void createReporter(String string) throws Fault {
        if (string != null) {
            try {
                Class<?> clazz = Class.forName(string);
                if (!Reporter.class.isAssignableFrom(clazz)) {
                    throw new Fault("This is not a valid reporter class");
                }
                this.reporter = (Reporter)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new Fault(classNotFoundException.toString());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new Fault(illegalAccessException.toString());
            }
            catch (InstantiationException instantiationException) {
                throw new Fault(instantiationException.toString());
            }
        } else {
            this.reporter = new PrintReporter();
        }
        this.reporter.init(this.reporterArgs, this.log, this.ref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Status runTest(Object object, Object[] objectArray, int[] nArray) {
        this.objectUnderTest = object;
        this.exeParameters = objectArray;
        this.exeSignature = nArray;
        this.canAssertionBeChecked = false;
        this.didAssertionFail = false;
        Status status = Status.passed("Test Started");
        this.reporter.reportTestData(object, objectArray, nArray);
        try {
            this.expectedExceptionSet = this.predictExceptionSet(objectArray);
            if (this.methodTest) {
                this.checkExceptionSet(this.expectedExceptionSet, this.methodUnderTest.getExceptionTypes());
            } else {
                this.checkExceptionSet(this.expectedExceptionSet, this.constructorUnderTest.getExceptionTypes());
            }
            this.savePreState();
            try {
                this.result = this.methodTest ? this.methodUnderTest.invoke(object, objectArray) : this.constructorUnderTest.newInstance(objectArray);
                status = this.analyzeNormally();
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                status = this.analyzeExceptionally(throwable);
            }
            catch (Error error) {
                status = this.analyzeExceptionally(error);
            }
            finally {
                this.releasePreState();
            }
        }
        catch (Fault fault) {
            status = Status.failed(fault.getMessage());
        }
        catch (ThreadDeath threadDeath) {
            this.reporter.reportException(threadDeath);
            throw threadDeath;
        }
        catch (Throwable throwable) {
            this.reporter.reportException(throwable);
            status = Status.failed(throwable.toString() + " raised.");
        }
        this.reporter.reportTestResult(this.result, status);
        return status;
    }

    private Status analyzeNormally() throws Fault {
        if (this.expectedExceptionSet.size() == 0) {
            try {
                this.canAssertionBeChecked = true;
                this.normalPostCondition();
                this.postCondition();
                this.canAssertionBeChecked = false;
                if (this.didAssertionFail) {
                    return Status.failed("Assertions failed: All Assertions Checked");
                }
                return Status.passed("Test Passed");
            }
            catch (Fault fault) {
                throw new Fault(fault.getMessage());
            }
        }
        return Status.failed("An exception was expected but was not raised");
    }

    private Status analyzeExceptionally(Throwable throwable) throws Fault {
        Throwable throwable2 = throwable;
        if (this.expectedExceptionSet.size() == 0) {
            return Status.failed("Unexpected Exception: " + throwable2.toString() + " raised");
        }
        if (this.expectedExceptionSet.contains(throwable2)) {
            try {
                ExpectedException[] expectedExceptionArray = this.expectedExceptionSet.getExceptionList(throwable2);
                this.canAssertionBeChecked = true;
                for (int i = 0; i < expectedExceptionArray.length; ++i) {
                    expectedExceptionArray[i].exceptionPostCondition();
                }
                this.postCondition();
                this.canAssertionBeChecked = false;
                if (this.didAssertionFail) {
                    return Status.failed("Assertions failed: All Assertions Checked");
                }
                return Status.passed("Test Passed");
            }
            catch (Fault fault) {
                throw new Fault(fault.getMessage());
            }
        }
        return Status.failed("Obtained Exception: " + throwable2.toString() + " is NOT an expected exception.");
    }

    public Method getMethod() {
        return this.methodUnderTest;
    }

    public Constructor getConstructor() {
        return this.constructorUnderTest;
    }

    public void hardAssert(boolean bl, String string) throws Fault {
        if (this.canAssertionBeChecked) {
            if (!bl) {
                this.didAssertionFail = true;
                this.reporter.reportAssertion(string, bl);
                throw new Fault("Assertion Failed");
            }
        } else {
            this.reporter.reportAssertion(string, bl);
            throw new Fault("Assertion checked from a non-postCondition method");
        }
        this.reporter.reportAssertion(string, bl);
    }

    public void softAssert(boolean bl, String string) throws Fault {
        if (this.canAssertionBeChecked) {
            if (!bl) {
                this.didAssertionFail = true;
                this.reporter.reportAssertion(string, bl);
            }
        } else {
            this.reporter.reportAssertion(string, bl);
            throw new Fault("Assertion checked from a non-postCondition method");
        }
        this.reporter.reportAssertion(string, bl);
    }

    protected AssertionTest() {
    }

    protected AssertionTest(Method method, Factory[] factoryArray) {
        this.methodUnderTest = method;
        this.methodTest = true;
        this.dataFactories = factoryArray;
    }

    protected AssertionTest(Constructor constructor, Factory[] factoryArray) {
        this.methodTest = false;
        this.constructorUnderTest = constructor;
        this.dataFactories = factoryArray;
    }

    protected void setMethodUnderTest(Method method) throws Fault {
        if (this.methodUnderTest != null) {
            throw new Fault("The method under test is already set.");
        }
        if (this.constructorUnderTest != null) {
            throw new Fault("A test can test a method or a constructor, but not both");
        }
        this.methodTest = true;
        this.methodUnderTest = method;
    }

    protected void setConstructorUnderTest(Constructor constructor) throws Fault {
        if (this.constructorUnderTest != null) {
            throw new Fault("The constructor is already set.");
        }
        if (this.methodUnderTest != null) {
            throw new Fault("A test can test a method or a constructor, but not both");
        }
        this.methodTest = false;
        this.constructorUnderTest = constructor;
    }

    protected void setDataFactories(Factory[] factoryArray) {
        this.dataFactories = factoryArray;
    }

    protected void savePreState() throws Fault {
    }

    protected void releasePreState() throws Fault {
    }

    protected void postCondition() throws Fault {
    }

    protected ExceptionSet predictExceptionSet(Object[] objectArray) {
        ExceptionSet exceptionSet = new ExceptionSet();
        return exceptionSet;
    }

    protected void normalPostCondition() throws Fault {
    }

    protected Object getObjectUnderTest() {
        return this.objectUnderTest;
    }

    protected Object[] getExecutionParameters() {
        return this.exeParameters;
    }

    protected Object getExecutionParameter(int n) {
        if (n < this.exeParameters.length) {
            return this.exeParameters[n];
        }
        return null;
    }

    protected Object getResult() {
        return this.result;
    }

    private void checkExceptionSet(ExceptionSet exceptionSet, Class[] classArray) throws Fault {
        block0: for (int i = 0; i < exceptionSet.size(); ++i) {
            ExpectedException expectedException = exceptionSet.getException(i);
            Class clazz = expectedException.getExceptionClass();
            for (int j = 0; j < classArray.length; ++j) {
                if (classArray[j].isAssignableFrom(clazz)) continue block0;
            }
            if (RuntimeException.class.isAssignableFrom(clazz) || Error.class.isAssignableFrom(clazz)) continue;
            throw new Fault(clazz.getName());
        }
    }

    public static class Fault
    extends Exception {
        public Fault(String string) {
            super(string);
        }
    }

    public class ExceptionSet {
        private Vector exceptionSet = new Vector();

        public void addException(ExpectedException expectedException) {
            this.exceptionSet.addElement(expectedException);
        }

        public int size() {
            return this.exceptionSet.size();
        }

        public ExpectedException[] getExceptionList(Throwable throwable) {
            Vector<ExpectedException> vector = new Vector<ExpectedException>();
            ExpectedException expectedException = new ExpectedException(null, null);
            for (int i = 0; i < this.exceptionSet.size(); ++i) {
                expectedException = this.getException(i);
                Class clazz = expectedException.getExceptionClass();
                if (!clazz.isAssignableFrom(throwable.getClass()) && !RuntimeException.class.isAssignableFrom(throwable.getClass()) && !Error.class.isAssignableFrom(throwable.getClass())) continue;
                vector.addElement(expectedException);
            }
            Object[] objectArray = new ExpectedException[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }

        public ExpectedException getException(int n) {
            return (ExpectedException)this.exceptionSet.elementAt(n);
        }

        public boolean contains(Throwable throwable) {
            for (int i = 0; i < this.exceptionSet.size(); ++i) {
                ExpectedException expectedException = this.getException(i);
                Class clazz = expectedException.getExceptionClass();
                if (!clazz.isAssignableFrom(throwable.getClass()) && !RuntimeException.class.isAssignableFrom(throwable.getClass()) && !Error.class.isAssignableFrom(throwable.getClass())) continue;
                return true;
            }
            return false;
        }
    }

    public class ExpectedException {
        private Class exceptionClass;
        private String message;

        public ExpectedException(Class clazz, String string) {
            this.message = string;
            if (clazz != null && !Throwable.class.isAssignableFrom(clazz)) {
                AssertionTest.this.log.println("Error:" + clazz.getName() + " is not a subclass of Throwable");
                return;
            }
            this.exceptionClass = clazz;
        }

        public ExpectedException(Class clazz) {
            this(clazz, clazz.getName());
        }

        public Class getExceptionClass() {
            return this.exceptionClass;
        }

        public String getMessage() {
            return this.message;
        }

        protected void exceptionPostCondition() throws Fault {
        }
    }
}

