/*
 * Decompiled with CFR 0.152.
 */
package javasoft.sqe.javatest.lib.apitest;

import java.util.Vector;
import javasoft.sqe.javatest.lib.apitest.AssertionTest;
import javasoft.sqe.javatest.lib.apitest.Factory;

public class ImmutableObjectFactory
implements Factory {
    private int initialCapacity;
    private Vector names;
    private Vector values;

    public ImmutableObjectFactory() {
        this.names = new Vector();
        this.values = new Vector();
    }

    public ImmutableObjectFactory(int initialCapacity, boolean includeNull) {
        this.names = new Vector(initialCapacity);
        this.values = new Vector(initialCapacity);
        if (includeNull) {
            this.names.addElement("null");
            this.values.addElement(null);
        }
    }

    public void add(String name, Object value) {
        this.names.addElement(name);
        this.values.addElement(value);
    }

    public int getSize() {
        return this.names.size();
    }

    public Object createElement(int i) throws AssertionTest.Fault {
        if (i > this.values.size()) {
            throw new AssertionTest.Fault("Error: test point index > factory length");
        }
        return this.values.elementAt(i);
    }

    public void disposeElement(Object obj) {
    }

    public String getName(int i) {
        return (String)this.names.elementAt(i);
    }

    public static ImmutableObjectFactory createDoubleFactory(double[] values) {
        return ImmutableObjectFactory.createDoubleFactory(values, false);
    }

    public static ImmutableObjectFactory createDoubleFactory(double[] values, boolean includeNull) {
        ImmutableObjectFactory df = new ImmutableObjectFactory(values.length, includeNull);
        for (int i = 0; i < values.length; ++i) {
            df.add(String.valueOf(values[i]), new Double(values[i]));
        }
        return df;
    }

    public static ImmutableObjectFactory createFloatFactory(float[] values) {
        return ImmutableObjectFactory.createFloatFactory(values, false);
    }

    public static ImmutableObjectFactory createFloatFactory(float[] values, boolean includeNull) {
        ImmutableObjectFactory df = new ImmutableObjectFactory(values.length, includeNull);
        for (int i = 0; i < values.length; ++i) {
            df.add(String.valueOf(values[i]), new Float(values[i]));
        }
        return df;
    }

    public static ImmutableObjectFactory createIntegerFactory(int[] values) {
        return ImmutableObjectFactory.createIntegerFactory(values, false);
    }

    public static ImmutableObjectFactory createIntegerFactory(int[] values, boolean includeNull) {
        ImmutableObjectFactory df = new ImmutableObjectFactory(values.length, includeNull);
        for (int i = 0; i < values.length; ++i) {
            df.add(String.valueOf(values[i]), new Integer(values[i]));
        }
        return df;
    }

    public static ImmutableObjectFactory createLongFactory(long[] values) {
        return ImmutableObjectFactory.createLongFactory(values, false);
    }

    public static ImmutableObjectFactory createLongFactory(long[] values, boolean includeNull) {
        ImmutableObjectFactory df = new ImmutableObjectFactory(values.length, includeNull);
        for (int i = 0; i < values.length; ++i) {
            df.add(String.valueOf(values[i]), new Long(values[i]));
        }
        return df;
    }

    public static ImmutableObjectFactory createCharacterFactory(char[] values) {
        return ImmutableObjectFactory.createCharacterFactory(values, false);
    }

    public static ImmutableObjectFactory createCharacterFactory(char[] values, boolean includeNull) {
        ImmutableObjectFactory df = new ImmutableObjectFactory(values.length, includeNull);
        for (int i = 0; i < values.length; ++i) {
            df.add(String.valueOf(values[i]), new Character(values[i]));
        }
        return df;
    }

    public static ImmutableObjectFactory createStringFactory(String[] values) {
        return ImmutableObjectFactory.createStringFactory(values, false);
    }

    public static ImmutableObjectFactory createStringFactory(String[] values, boolean includeNull) {
        ImmutableObjectFactory df = new ImmutableObjectFactory(values.length, includeNull);
        for (int i = 0; i < values.length; ++i) {
            df.add(values[i], values[i]);
        }
        return df;
    }

    public static ImmutableObjectFactory createBooleanFactory(boolean[] values) {
        return ImmutableObjectFactory.createBooleanFactory(values, false);
    }

    public static ImmutableObjectFactory createBooleanFactory(boolean[] values, boolean includeNull) {
        ImmutableObjectFactory df = new ImmutableObjectFactory(values.length, includeNull);
        for (int i = 0; i < values.length; ++i) {
            df.add(String.valueOf(values[i]), new Boolean(values[i]));
        }
        return df;
    }

    public static ImmutableObjectFactory createObjectFactory(Object[] values) {
        return ImmutableObjectFactory.createObjectFactory(values, false);
    }

    public static ImmutableObjectFactory createObjectFactory(Object[] values, boolean includeNull) {
        ImmutableObjectFactory df = new ImmutableObjectFactory(values.length, includeNull);
        for (int i = 0; i < values.length; ++i) {
            df.add(String.valueOf(values[i]), values[i]);
        }
        return df;
    }
}

