/*
 * Decompiled with CFR 0.152.
 */
package javasoft.sqe.javatest.lib.apitest;

import java.util.StringTokenizer;
import java.util.Vector;
import javasoft.sqe.javatest.Status;
import javasoft.sqe.javatest.lib.MultiStatus;
import javasoft.sqe.javatest.lib.apitest.AssertionTest;
import javasoft.sqe.javatest.lib.apitest.Factory;
import javasoft.sqe.javatest.lib.apitest.Generator;

public class SingletonGenerator
implements Generator {
    private AssertionTest testObject;
    private Factory[] factory;
    private MultiStatus overallStatus;
    private Vector testPointVector = new Vector();
    private Vector testData = new Vector();

    public Status run(AssertionTest testObject, Factory[] paramFactory) {
        this.testObject = testObject;
        this.factory = paramFactory;
        this.overallStatus = new MultiStatus();
        try {
            this.createTestData(this.testPointVector);
            this.executeTestCases(this.testData);
        }
        catch (AssertionTest.Fault f) {
            return Status.failed(f.getMessage());
        }
        return this.overallStatus.getStatus();
    }

    public void init(String[] args) throws AssertionTest.Fault {
        try {
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    if (args[i].equals("-reporter")) {
                        throw new AssertionTest.Fault("There was no -end at the end of the argument list for Generator");
                    }
                    if (!args[i].equals("-testPoint")) continue;
                    ++i;
                    while (i < args.length) {
                        this.testPointVector.addElement(args[i]);
                        ++i;
                    }
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            throw new AssertionTest.Fault(ae.getMessage() + " raised in generator's init() method");
        }
    }

    private void createTestData(Vector v) {
        for (int i = 0; i < v.size(); ++i) {
            int[] param = new int[this.factory.length];
            String elem = (String)v.elementAt(i);
            StringTokenizer st = new StringTokenizer(elem, ":");
            int index = 0;
            while (st.hasMoreElements()) {
                Integer val = new Integer((String)st.nextElement());
                param[index] = val;
                ++index;
            }
            this.testData.addElement(param);
        }
    }

    private void executeTestCases(Vector v) throws AssertionTest.Fault {
        String testID = "";
        try {
            for (int j = 0; j < v.size(); ++j) {
                testID = "";
                int[] p = new int[this.factory.length];
                p = (int[])v.elementAt(j);
                Object[] exeParameters = new Object[p.length - 1];
                Object objectUnderTest = null;
                for (int i = 0; i < p.length; ++i) {
                    testID = testID + String.valueOf(p[i]) + ":";
                    if (i == 0) {
                        objectUnderTest = this.factory[i].createElement(p[i]);
                        continue;
                    }
                    exeParameters[i - 1] = this.factory[i].createElement(p[i]);
                }
                Status testStatus = this.testObject.runTest(objectUnderTest, exeParameters, p);
                this.overallStatus.add(testID, testStatus);
                this.factory[0].disposeElement(objectUnderTest);
            }
        }
        catch (AssertionTest.Fault f) {
            throw new AssertionTest.Fault(f.getMessage() + " Execution Signature at this point: " + testID);
        }
    }
}

