/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest;

import com.sun.tdk.signaturetest.Result;
import com.sun.tdk.signaturetest.Version;
import com.sun.tdk.signaturetest.classpath.Classpath;
import com.sun.tdk.signaturetest.core.AppContext;
import com.sun.tdk.signaturetest.core.ClassDescriptionLoader;
import com.sun.tdk.signaturetest.core.ClassHierarchy;
import com.sun.tdk.signaturetest.core.Log;
import com.sun.tdk.signaturetest.core.MemberCollectionBuilder;
import com.sun.tdk.signaturetest.core.PackageGroup;
import com.sun.tdk.signaturetest.core.ThrowsNormalizer;
import com.sun.tdk.signaturetest.core.context.BaseOptions;
import com.sun.tdk.signaturetest.core.context.Option;
import com.sun.tdk.signaturetest.errors.ErrorFormatter;
import com.sun.tdk.signaturetest.model.AnnotationItem;
import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.plugin.Context;
import com.sun.tdk.signaturetest.plugin.Filter;
import com.sun.tdk.signaturetest.plugin.MessageTransformer;
import com.sun.tdk.signaturetest.plugin.Plugin;
import com.sun.tdk.signaturetest.plugin.PluginAPI;
import com.sun.tdk.signaturetest.plugin.Transformer;
import com.sun.tdk.signaturetest.sigfile.AnnotationParser;
import com.sun.tdk.signaturetest.sigfile.FileManager;
import com.sun.tdk.signaturetest.sigfile.Format;
import com.sun.tdk.signaturetest.util.CommandLineParserException;
import com.sun.tdk.signaturetest.util.I18NResourceBundle;
import com.sun.tdk.signaturetest.util.SwissKnife;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class SigTest
extends Result
implements PluginAPI,
Log {
    public static final String APIVERSION_OPTION = "-ApiVersion";
    public static final String CLASSCACHESIZE_OPTION = "-ClassCacheSize";
    public static final String VERBOSE_OPTION = "-Verbose";
    public static final String XVERBOSE_OPTION = "-Xverbose";
    public static final String XNOTIGER_OPTION = "-XnoTiger";
    public static final String OUT_OPTION = "-Out";
    public static final String EXTENSIBLE_INTERFACES_OPTION = "-ExtensibleInterfaces";
    public static final String PLUGIN_OPTION = "-Plugin";
    public static final String ERRORALL_OPTION = "-ErrorAll";
    public static final String NOWARN = "nowarn";
    public static final String NOERR = "noerr";
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(SigTest.class);
    protected String sigFileNameList = null;
    private FileManager fm = new FileManager();
    protected PackageGroup packages;
    protected PackageGroup purePackages;
    protected PackageGroup excludedPackages;
    protected PackageGroup apiIncl;
    protected PackageGroup apiExcl;
    private ErrorFormatter errorManager;
    protected String apiVersion = "";
    protected MemberCollectionBuilder testableMCBuilder;
    protected ThrowsNormalizer normalizer = new ThrowsNormalizer();
    protected boolean nowarnings = false;
    protected boolean noerrors = false;
    public static boolean isConstantValuesTracked = true;
    public static final int DefaultCacheSize = 1024;
    protected int cacheSize = 1024;
    public static boolean isTigerFeaturesTracked = false;
    private static boolean isJava8 = false;
    protected Plugin pluginClass = null;
    protected boolean isVerbose = false;
    static boolean Xverbose;
    protected ClassHierarchy testableHierarchy;
    protected Set errorMessages = new HashSet();
    private ClassDescriptionLoader loader;
    protected boolean reportWarningAsError = false;
    protected int errors;

    protected void setErrorManager(ErrorFormatter em) {
        this.errorManager = em;
    }

    protected ErrorFormatter getErrorManager() {
        return this.errorManager;
    }

    public boolean isConstantValuesTracked() {
        return isConstantValuesTracked;
    }

    public void setConstantValuesTracked(boolean t) {
        isConstantValuesTracked = t;
    }

    protected SigTest() {
        this.packages = new PackageGroup(true);
        this.purePackages = new PackageGroup(false);
        this.excludedPackages = new PackageGroup(true);
        this.apiIncl = new PackageGroup(true);
        this.apiExcl = new PackageGroup(true);
    }

    public void initErrors() {
        this.errorMessages.clear();
    }

    @Override
    public void storeError(String s, Logger utilLogger) {
        if (utilLogger != null && utilLogger.isLoggable(Level.SEVERE)) {
            utilLogger.severe(s);
        }
        this.errorMessages.add(s);
    }

    @Override
    public void storeWarning(String s, Logger utilLogger) {
        if (this.reportWarningAsError) {
            this.storeError(s, utilLogger);
            return;
        }
        if (utilLogger != null && utilLogger.isLoggable(Level.WARNING)) {
            utilLogger.warning(s);
        }
        if (!this.nowarnings) {
            this.getLog().println(i18n.getString("SigTest.warning", s));
        }
    }

    public void printErrors() {
        Iterator it = this.errorMessages.iterator();
        while (it.hasNext()) {
            this.setupProblem((String)it.next());
        }
        this.initErrors();
    }

    protected void setupProblem(String msg) {
        if (!this.noerrors) {
            this.getLog().println(msg);
            ++this.errors;
        }
    }

    protected void setLog(PrintWriter w) {
        assert (w != null);
        AppContext.getContext().setLogWriter(w);
    }

    public PrintWriter getLog() {
        return AppContext.getContext().getLogWriter();
    }

    protected void decodeCommonOptions(String optionName, String[] args) throws CommandLineParserException {
        BaseOptions bo = AppContext.getContext().getBean(BaseOptions.class);
        if (bo.readOptions(optionName, args)) {
            return;
        }
        if (optionName.equalsIgnoreCase(APIVERSION_OPTION)) {
            this.apiVersion = args[0];
        } else if (optionName.equalsIgnoreCase(CLASSCACHESIZE_OPTION)) {
            this.cacheSize = 0;
            try {
                this.cacheSize = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException ex) {
                if (bo.isSet(Option.DEBUG)) {
                    SwissKnife.reportThrowable(ex);
                }
                this.cacheSize = 0;
            }
            if (this.cacheSize <= 0) {
                throw new CommandLineParserException(i18n.getString("SigTest.error.arg.invalid", optionName));
            }
        } else if (optionName.equalsIgnoreCase(ERRORALL_OPTION)) {
            this.reportWarningAsError = true;
        } else if (optionName.equalsIgnoreCase(XNOTIGER_OPTION)) {
            isTigerFeaturesTracked = false;
        } else if (optionName.equalsIgnoreCase(XVERBOSE_OPTION)) {
            Xverbose = true;
        } else if (optionName.equalsIgnoreCase(VERBOSE_OPTION)) {
            if (args.length > 0) {
                if (args[0].equalsIgnoreCase(NOWARN)) {
                    this.nowarnings = true;
                }
            } else if (args.length > 0) {
                if (args[0].equalsIgnoreCase(NOERR)) {
                    this.noerrors = true;
                }
            } else {
                this.isVerbose = true;
            }
        } else if (optionName.equalsIgnoreCase(PLUGIN_OPTION)) {
            this.pluginClass = this.loadPlugin(args[0]);
            if (this.pluginClass == null) {
                throw new CommandLineParserException(i18n.getString("SigTest.error.cant_load.plugin", args[0]));
            }
        }
    }

    protected boolean processHelpOptions() {
        BaseOptions bo = AppContext.getContext().getBean(BaseOptions.class);
        if (bo.isSet(Option.HELP)) {
            this.usage();
            this.notrun();
            return false;
        }
        if (bo.isSet(Option.VERSION)) {
            System.err.println(Version.getVersionInfo());
        }
        return true;
    }

    public int getNumErrors() {
        return this.errorManager.getNumErrors();
    }

    public int getNumWarnings() {
        return this.errorManager.getNumWarnings();
    }

    protected boolean isPackageMember(String name) {
        boolean excluded = this.excludedPackages.checkName(name) || this.apiExcl.checkName(name);
        boolean included = this.packages.checkName(name) || this.purePackages.checkName(name) || this.apiIncl.checkName(name);
        return included && !excluded;
    }

    @Override
    public void setClassDescrLoader(ClassDescriptionLoader loader) {
        this.loader = loader;
    }

    protected ClassDescriptionLoader getClassDescrLoader() {
        if (this.loader != null) {
            return this.loader;
        }
        BaseOptions bo = AppContext.getContext().getBean(BaseOptions.class);
        if (bo.isSet(Option.STATIC)) {
            this.loader = SigTest.getLoader("com.sun.tdk.signaturetest.loaders.BinaryClassDescrLoader", new Class[]{Classpath.class, Integer.class}, new Object[]{this.getClasspath(), new Integer(this.cacheSize)}, this.getLog());
            if (this.loader == null) {
                throw new LinkageError(i18n.getString("SigTest.error.mgr.linkerr.loadstatic"));
            }
        } else {
            if (isJava8) {
                this.loader = SigTest.getLoader("com.sun.tdk.signaturetest.loaders.J8RefLoader", new Class[0], new Object[0], this.getLog());
                if (this.loader != null) {
                    return this.loader;
                }
            }
            if (isTigerFeaturesTracked) {
                this.loader = SigTest.getLoader("com.sun.tdk.signaturetest.loaders.TigerRefgClassDescrLoader", new Class[0], new Object[0], this.getLog());
                if (this.loader != null) {
                    return this.loader;
                }
                isTigerFeaturesTracked = false;
            }
            this.loader = SigTest.getLoader("com.sun.tdk.signaturetest.loaders.ReflClassDescrLoader", new Class[0], new Object[0], this.getLog());
            if (this.loader == null) {
                throw new LinkageError(i18n.getString("SigTest.error.mgr.linkerr.loadreflect"));
            }
        }
        return this.loader;
    }

    protected ClassDescription load(String name) {
        BaseOptions bo = AppContext.getContext().getBean(BaseOptions.class);
        try {
            return this.testableHierarchy.load(name);
        }
        catch (ClassNotFoundException e) {
            if (bo.isSet(Option.DEBUG)) {
                SwissKnife.reportThrowable(e);
            }
            this.storeError(i18n.getString("SigTest.error.class.missing", name), null);
        }
        catch (LinkageError e) {
            if (bo.isSet(Option.DEBUG)) {
                SwissKnife.reportThrowable(e);
            }
            this.storeError(i18n.getString("SigTest.error.class.notlinked", e.getMessage()), null);
        }
        return null;
    }

    private static ClassDescriptionLoader getLoader(String name, Class[] pars, Object[] args, PrintWriter log) {
        try {
            Constructor<?> ctor = Class.forName(name).getConstructor(pars);
            ClassDescriptionLoader cl = (ClassDescriptionLoader)ctor.newInstance(args);
            try {
                Method setLog = cl.getClass().getDeclaredMethod("setLog", PrintWriter.class);
                setLog.invoke((Object)cl, log);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            return cl;
        }
        catch (Throwable t) {
            SwissKnife.reportThrowable(t);
            return null;
        }
    }

    public boolean useErasurator() {
        return !isTigerFeaturesTracked;
    }

    protected abstract void usage();

    protected abstract String getComponentName();

    protected Plugin loadPlugin(String pluginClassName) {
        BaseOptions bo = AppContext.getContext().getBean(BaseOptions.class);
        try {
            Constructor<?> ctor = Class.forName(pluginClassName).getConstructor(new Class[0]);
            return (Plugin)ctor.newInstance(new Object[0]);
        }
        catch (Throwable t) {
            if (bo.isSet(Option.DEBUG)) {
                SwissKnife.reportThrowable(t);
            }
            return null;
        }
    }

    @Override
    public Filter getFilter(PluginAPI.InjectionPoint injectionPoint) {
        return injectionPoint.getFilter();
    }

    @Override
    public void setFilter(PluginAPI.InjectionPoint injectionPoint, Filter filter) {
        injectionPoint.setFilter(filter);
    }

    @Override
    public Transformer getTransformer(PluginAPI.InjectionPoint injectionPoint) {
        return injectionPoint.getTransformer();
    }

    @Override
    public void setTransformer(PluginAPI.InjectionPoint injectionPoint, Transformer transformer) {
        injectionPoint.setTransformer(transformer);
    }

    @Override
    public void setMessageTransformer(PluginAPI.InjectionPoint injectionPoint, MessageTransformer messageTransformer) {
        injectionPoint.setMessageTransformer(messageTransformer);
    }

    protected boolean addInherited() {
        return true;
    }

    @Override
    public Context getContext() {
        throw new UnsupportedOperationException("This method is not implemented");
    }

    @Override
    public void addFormat(Format format, boolean useByDefault) {
        this.getFileManager().addFormat(format, useByDefault);
    }

    @Override
    public void setFormat(Format format) {
        this.getFileManager().setFormat(format);
    }

    protected AnnotationItem[] removeUndocumentedAnnotations(AnnotationItem[] annotations, ClassHierarchy h) {
        if (annotations == null) {
            return AnnotationItem.EMPTY_ANNOTATIONITEM_ARRAY;
        }
        int len = annotations.length;
        AnnotationItem[] tempStorage = new AnnotationItem[len];
        if (len == 0) {
            return annotations;
        }
        int count = 0;
        for (int i = 0; i < len; ++i) {
            boolean documented = true;
            try {
                documented = h.isDocumentedAnnotation(annotations[i].getName());
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (!documented) continue;
            tempStorage[count++] = annotations[i];
        }
        if (count == len) {
            return annotations;
        }
        AnnotationItem[] documentedAnnotations = AnnotationItem.EMPTY_ANNOTATIONITEM_ARRAY;
        if (count != 0) {
            documentedAnnotations = new AnnotationItem[count];
            System.arraycopy(tempStorage, 0, documentedAnnotations, 0, count);
        }
        return documentedAnnotations;
    }

    protected AnnotationItem[] unpackContainerAnnotations(AnnotationItem[] annotations, ClassHierarchy ch) {
        ArrayList<AnnotationItem> unpackedAnnotations = new ArrayList<AnnotationItem>();
        ArrayList<AnnotationItem> toRemove = new ArrayList<AnnotationItem>();
        AnnotationParser ap = new AnnotationParser();
        for (int i = 0; i < annotations.length; ++i) {
            try {
                List newAnns;
                AnnotationItem.Member memval;
                AnnotationItem ai = annotations[i];
                unpackedAnnotations.add(ai);
                if (!ch.isContainerAnnotation(ai.getName()) || (memval = ai.findByName("value")) == null || (newAnns = ap.unpack(memval.value)) == null || newAnns.size() <= 0) continue;
                unpackedAnnotations.addAll(newAnns);
                toRemove.add(ai);
                continue;
            }
            catch (ClassNotFoundException ex) {
                // empty catch block
            }
        }
        unpackedAnnotations.removeAll(toRemove);
        return unpackedAnnotations.toArray(new AnnotationItem[0]);
    }

    protected AnnotationItem[] normalizeArrayParaemeters(AnnotationItem[] annotations, Set exclusions, ClassHierarchy ch) {
        for (int i = 0; i < annotations.length; ++i) {
            try {
                if (ch.isContainerAnnotation(annotations[i].getName())) continue;
                AnnotationItem.normaliazeAnnotation(annotations[i], exclusions);
                continue;
            }
            catch (ClassNotFoundException ex) {
                AnnotationItem.normaliazeAnnotation(annotations[i], exclusions);
            }
        }
        return annotations;
    }

    protected FileManager getFileManager() {
        return this.fm;
    }

    protected Classpath getClasspath() {
        return AppContext.getContext().getInputClasspath();
    }

    protected void setClasspath(Classpath classpath) {
        AppContext.getContext().setInputClasspath(classpath);
    }

    static {
        try {
            String specVersion = System.getProperty("java.specification.version");
            if ("1.5".compareTo(specVersion) <= 0) {
                isTigerFeaturesTracked = true;
            }
            if ("1.8".compareTo(specVersion) <= 0) {
                isTigerFeaturesTracked = true;
                isJava8 = true;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        Xverbose = false;
    }
}

