/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.model;

import com.sun.tdk.signaturetest.model.AnnotationItem;
import com.sun.tdk.signaturetest.model.MemberDescription;
import com.sun.tdk.signaturetest.model.MemberType;
import com.sun.tdk.signaturetest.model.Modifier;
import com.sun.tdk.signaturetest.util.SwissKnife;
import java.util.Set;
import java.util.StringTokenizer;

public final class MethodDescr
extends MemberDescription {
    public static final MethodDescr[] EMPTY_ARRAY = new MethodDescr[0];
    private Object annoDef;

    public MethodDescr() {
        super(MemberType.METHOD, '.');
    }

    public MethodDescr(String methodName, String className, int modifiers) {
        super(MemberType.METHOD, '.');
        this.setupMemberName(methodName, className);
        this.setModifiers(modifiers);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof MethodDescr)) {
            return false;
        }
        MethodDescr method = (MethodDescr)o;
        return this.name == method.name && this.args.equals(method.args) && SwissKnife.equals(this.typeParameters, method.typeParameters);
    }

    @Override
    public int hashCode() {
        return this.name.hashCode() + this.args.hashCode() + (this.typeParameters != null ? this.typeParameters.hashCode() : 0);
    }

    @Override
    public boolean isCompatible(MemberDescription m) {
        if (!this.equals(m)) {
            throw new IllegalArgumentException("Only equal members can be checked for compatibility!");
        }
        return this.memberType.isCompatible(this.getModifiers(), m.getModifiers()) && this.type.equals(m.type) && this.throwables.equals(m.throwables);
    }

    @Override
    public boolean isMethod() {
        return true;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("method");
        String modifiers = Modifier.toString(this.memberType, this.getModifiers(), true);
        if (modifiers.length() != 0) {
            buf.append(' ');
            buf.append(modifiers);
        }
        if (this.typeParameters != null) {
            buf.append(' ');
            buf.append(this.typeParameters);
        }
        if (this.type.length() != 0) {
            buf.append(' ');
            buf.append(this.type);
        }
        buf.append(' ');
        buf.append(this.declaringClass);
        buf.append(this.delimiter);
        buf.append(this.name);
        buf.append('(');
        buf.append(this.args);
        buf.append(')');
        if (this.throwables.length() > 0) {
            buf.append(" throws ");
            buf.append(this.throwables);
        }
        AnnotationItem[] annoList = this.getAnnoList();
        for (int i = 0; i < annoList.length; ++i) {
            buf.append("\n ");
            buf.append(annoList[i]);
        }
        return buf.toString();
    }

    public String getSignature() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.name);
        buf.append('(');
        buf.append(this.args);
        buf.append(')');
        return buf.toString();
    }

    public Object getAnnoDef() {
        return this.annoDef;
    }

    public void setAnnoDef(Object annodef) {
        this.annoDef = annodef;
    }

    @Override
    protected void populateDependences(Set set) {
        this.addDependency(set, this.type);
        StringTokenizer st = new StringTokenizer(this.args, ",");
        while (st.hasMoreTokens()) {
            this.addDependency(set, st.nextToken());
        }
        st = new StringTokenizer(this.throwables, ",");
        while (st.hasMoreTokens()) {
            this.addDependency(set, st.nextToken());
        }
    }
}

