/*
 * Copyright (c) 1997-2017 Oracle and/or its affiliates. All rights reserved.
 */

package	javasoft.sqe.tests.api.javax.activation.CommandMap;

import	java.io.*;
import	javax.activation.*;
import	com.sun.javatest.*;
import	javasoft.sqe.tests.api.javax.activation.TestClasses.*;

/** CommandMap is an abstract class. The main functional testing is in the only
 *  provided concrete implementation, MailcapCommandMap, done separately. <p>
 *  Call the getCommand() api with string values if it returns non-null object
 *  of type CommandInfo then this testcase passes, otherwise it fails. <p>
 */

public class getCommand_Test implements Test
{
	public static void main(String argv[])
	{
		getCommand_Test lTest = new getCommand_Test();
		Status lStatus = lTest.run(argv, new PrintWriter(System.err, true), new PrintWriter(System.out, true));
		lStatus.exit();
	}

	public Status run(String argv[], PrintWriter outLog, PrintWriter outConsole)
	{
		// We are not going to require any 'default' viewer objects,
		// We will explicitly create a commandmap with one.

		MailcapCommandMap mcm = new MailcapCommandMap();
		mcm.addMailcap("text/plain; ; x-java-fooblatz=com.foo.Mailcap");

		CommandMap.setDefaultCommandMap(mcm);
		CommandMap lCommandMap = CommandMap.getDefaultCommandMap();

		if(!(lCommandMap instanceof MailcapCommandMap))
		   return Status.failed("getDefaultCommandMap() did not return MailcapCommandMap");

		CommandInfo comap = lCommandMap.getCommand("text/plain", "fooblatz");	// API TEST

		if( comap == null )
		    return Status.failed("getCommand failed to return CommandInfo object!");

		return Status.passed("getCommand() Test succeeded");
	}
}
