/*
 * Copyright (c) 1997-2017 Oracle and/or its affiliates. All rights reserved.
 */

package	javasoft.sqe.tests.api.javax.activation.CommandMap;

import	java.io.*;
import	javax.activation.*;
import	com.sun.javatest.*;
import	javasoft.sqe.tests.api.javax.activation.TestClasses.*;

/** CommandMap is an abstract class. The main functional testing is in the only
 *  provided concrete implementation, MailcapCommandMap, done separately.<p>
 *  We first get default CommandMap object then using it call setDefaultCommandMap()
 *  with CommandMap/Null object parameter and if these operation is successfull
 *  then this testcase passes otherwise it fails.
 */

public class setDefaultCommandMap_Test implements Test
{
	public static void main(String argv[])
	{
		setDefaultCommandMap_Test lTest = new setDefaultCommandMap_Test();
		Status lStatus = lTest.run(argv, new PrintWriter(System.err, true), new PrintWriter(System.out, true));
		lStatus.exit();
	}

	public Status run(String argv[], PrintWriter outLog, PrintWriter outConsole)
	{
		// does getDefaultCommandMap return a MailcapCommandMap?
		CommandMap lCommandMap = CommandMap.getDefaultCommandMap();

		if (!(lCommandMap instanceof MailcapCommandMap))
	    	    return Status.failed("getDefaultCommandMap() did not return MailcapCommandMap");
	 
		// Does setDefaultCommandMap work?   
		lCommandMap = new TestCommandMap(null);
		CommandMap.setDefaultCommandMap(lCommandMap);	// API TEST

		if (!lCommandMap.equals(CommandMap.getDefaultCommandMap()))
		    return Status.failed("getDefaultCommandMap failed to return CommandMap provided in setDefaultCommandMap");

		// Does setDefaultCommandMap(null) reset the default?
		CommandMap.setDefaultCommandMap(null);		// API TEST
		lCommandMap = CommandMap.getDefaultCommandMap();

		if (!(lCommandMap instanceof MailcapCommandMap))
		    return Status.failed("setDefaultCommandMap(null) didn't reset default to MailcapCommandMap");

		return Status.passed("setDefaultCommandMap Test succeeded");
	}
}
