/*
 * Copyright (c) 1997-2017 Oracle and/or its affiliates. All rights reserved.
 */

package	javasoft.sqe.tests.api.javax.activation.FileTypeMap;

import	java.io.*;
import	javax.activation.*;
import	com.sun.javatest.*;
import	javasoft.sqe.tests.api.javax.activation.TestClasses.TestFileTypeMap;

/** FileTypeMap is an abstract class. The main functional testing is in the only provided
 *  concrete implementation, MimetypesFileTypeMap, tested separately.<p> 
 *  Create an instance of FileTypeMap, then use it to call getContentType() api,
 *  with various {File|String} parameters. If this method returns a non-null 
 *  string object then this testcase passes, otherwise it fails. <p>
 */

public class getContentType_Test implements Test
{

public static void main(String argv[])
{
	getContentType_Test lTest = new getContentType_Test();
	Status lStatus = lTest.run(argv, new PrintWriter(System.err, true), new PrintWriter(System.out, true));
	lStatus.exit();
}

public Status run(String argv[], PrintWriter outLog, PrintWriter outConsole)
{
	File fob = new File("testfile.txt");
	FileTypeMap ftm = FileTypeMap.getDefaultFileTypeMap();
	String content1 = ftm.getContentType(fob);		// API TEST

	if( content1 == null )
	    return Status.failed("getContentType() returned null");

	String content2 = ftm.getContentType("testfile.txt");	// API TEST

	if( content2 == null )
	    return Status.failed("getContentType() returned null");

	return Status.passed("getContentType() test succeeded");
}

}
