/*
 * Copyright (c) 1997-2017 Oracle and/or its affiliates. All rights reserved.
 */

package	javasoft.sqe.tests.api.javax.activation.MimeType;

import	java.io.*;
import	java.util.Enumeration;
import	javax.activation.*;
import	com.sun.javatest.*;
import	com.sun.javatest.lib.MultiTest; 

/**
 * Create a MimeType instance, use it to call getParameters() method, if it
 * returns enumerated list of MimeTypeParameterList, then this test passes,
 * otherwise it fails. <p>
 */

public class getParameters_Test extends MultiTest
{

public static void main(String argv[])
{
	getParameters_Test lTest = new getParameters_Test();
	Status lStatus = lTest.run(argv, new PrintWriter(System.err, true), new PrintWriter(System.out, true));
	lStatus.exit();
}

public Status	getParametersTest()
{	
        try {	// create a MimeType object
                MimeType jmt =  new MimeType("text/plain;charset=us-ascii;isoset=iso-9000;abc=xyz");

                if( jmt == null )
                    return Status.failed("Failed: to create MimeType object using constructor");

                MimeTypeParameterList mtpl =  jmt.getParameters();       // API TEST

                if( mtpl == null )
                    return Status.failed("Failed: getParameters() returned null string!");

		Enumeration hlist = mtpl.getNames();

                while( hlist.hasMoreElements() ) {
                       String name = (String)hlist.nextElement();
                       //out.println(name);
                }

        } catch(Exception ex) {
                return Status.failed("getParameters() threw " + ex.toString());
        }

        return Status.passed("getParameters() test succeeded");
}
}
