/*
 * Copyright (c) 1997-2017 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.api.javax.activation.MimeType;

import	java.io.*;
import	javax.activation.*;
import	com.sun.javatest.*;
import	com.sun.javatest.lib.MultiTest; 

/**
 * Create a MimeType instance, use it to call setPrimaryType() method
 * with primary type string parameter, then call getPrimaryType(), if
 * set/get values are equal, then this test passes otherwise it fails. <p>
 */

public class setPrimaryType_Test extends MultiTest
{
public static void main(String argv[])
{
	setPrimaryType_Test lTest = new setPrimaryType_Test();
	Status lStatus = lTest.run(argv, new PrintWriter(System.err, true), new PrintWriter(System.out, true));
	lStatus.exit();
}

public Status setPrimaryTypeTest()
{
	try {	// create MimeType object
		MimeType objmt =  new MimeType();

		if( objmt == null )
		    return Status.failed("Failed: to create MimeType object using constructor");

                objmt.setPrimaryType("html");       // API TEST

                if( !(objmt.getPrimaryType()).equals("html") )
                    return Status.failed("Failed: setPrimaryType(String) returned different string.");

                objmt.setPrimaryType("text");       // API TEST

                if( !(objmt.getPrimaryType()).equals("text") )
                    return Status.failed("Failed: setPrimaryType(String) returned different string.");

                objmt.setPrimaryType("");       // API TEST

                if( !(objmt.getPrimaryType()).equals("") )
                    return Status.failed("Failed: setPrimaryType(String) returned different string.");

	} catch(Exception ex) {
		ex.printStackTrace();
		return Status.failed("setPrimaryType(string) threw " + ex.toString());
	}

	return Status.passed("setPrimaryType(string) test succeeded");
}

}
