/*
 * Copyright (c) 2002-2015 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.javax.mail.Message;

import java.util.*;
import java.io.*;
import javax.mail.*;
import javax.mail.internet.*;
import com.sun.javatest.*;
import javasoft.sqe.tests.javax.mail.util.MailTest;

/**
 * This class tests the <strong>getFileName()</strong> API.
 * It does this by invoking the test api and then checking
 * the type of the returned object.	<p>
 *
 *		Get the filename associated with this Message. <p>
 * api2test: public String getFileName()  <p>
 *
 * how2test: Call this API, check that it returns a string. If this is the
 *	     case then this testcase passes, otherwise it fails.
 */

public class getFileName_Test extends MailTest {

    public static String fileName;

    public static void main( String argv[] )
    {
        getFileName_Test test = new getFileName_Test();
        Status s = test.run(argv, System.err, System.out);
	s.exit();
    }

    public Status run(String argv[], PrintWriter log, PrintWriter out)
    {
	super.run(argv, log, out);
	parseArgs(argv);	// parse command-line options

        out.println("\nTesting class Message: getFileName()\n");

        try {
          // Connect to host server
             Store store = connect2host(protocol, host, user, password);

          // Get a Folder object
	     Folder root = getRootFolder(store);
             Folder folder = root.getFolder(mailbox);

             if( folder == null ) {
                 return Status.failed("Invalid folder object!");
             }
             folder.open(Folder.READ_ONLY);

	     if( msgcount == -1 ) {
                 msgcount = folder.getMessageCount();
                 if( msgcount < 1 )
                     return Status.failed("Mail folder is empty!");
             }

             for ( int i = 1; i <= msgcount; i++ )
             {
             // Get the message
                MimeMessage msg = (MimeMessage)folder.getMessage(i);

	        if( msg == null ) {
		    log.println("WARNING: FAILED TO GET MESSAGE NUMBER: "+ i);
		    continue;
	        }
	     // BEGIN UNIT TEST:
		// Returns the filename associated with this message
	        out.println("UNIT TEST "+ i +":  getFileName()");

	        fileName = msg.getFileName();	// API TEST
	        out.println("getFileName() :=> "+ fileName);

	        if( fileName != null )
                    out.println("UNIT TEST "+ i +":  passed\n");
	        else {
		      out.println("Caution: FileName is null for this message body");
		      out.println("UNIT TEST "+ i +":  passed\n");
	        }
	     // END UNIT TEST:
	     }
	     folder.close(false);
	     store.close();
             checkStatus();

        } catch ( Exception e ) {
	     handlException(e);
        }
	return status;
     }
}
