/*
 * Copyright (c) 2002-2015 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.javax.mail.Session;

import java.util.*;
import java.io.*;
import javax.mail.*;
import com.sun.javatest.*;
import javasoft.sqe.tests.javax.mail.util.MailTest;

/**
 * This class tests the <strong>setProvider()</strong> API.
 * It does this by passing various valid input values and then checking
 * the type of the returned object.	<p>
 *
 *	Set the passed Provider to be the default implementation for the protocol. <p>
 * api2test: public void setProvider(Provider)  <p>
 *
 * how2test: Call this API with a Provider argument, then check by calling getProvider()
 *	     If both values are same then this testcase passes.
 */

public class setProvider_Test extends MailTest {

    public static void main( String argv[] )
    {
        setProvider_Test test = new setProvider_Test();
        Status s = test.run(argv, System.err, System.out);
	s.exit();
    }

    public Status run(String argv[], PrintWriter log, PrintWriter out)
    {
	super.run(argv, log, out);
	parseArgs(argv);	// parse command-line options

        out.println("\nTesting class Session: setProvider(URLName, Provider)\n");

        try {
           // Get Session object
              Session session = Session.getInstance(properties, null);

	   // Initialize a new Provider
	      Provider prov1 = session.getProvider(protocol);

              if( prov1 == null )
                  return Status.failed("Failed to initialize a Provider object!");

           // BEGIN UNIT TEST 1:
              out.println("UNIT TEST 1:  setProvider(Provider)");

              session.setProvider(prov1);  // API TEST
	      Provider prov2 = session.getProvider(protocol);

              if( prov1.equals(prov2) )
                  out.println("UNIT TEST 1: passed");
	      else {
		    out.println("UNIT TEST 1: FAILED.\n");
		    errors++;
	      }
           // END UNIT TEST 1:
	      checkStatus();

        } catch ( Exception e ) {
	      handlException(e);
        }
	return status;
     }
}
