/*
 * Copyright (c) 2002-2015 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.javax.mail.internet.InternetHeaders;

import java.util.*;
import java.io.*;
import javax.mail.*;
import javax.mail.internet.*;
import com.sun.javatest.*;
import javasoft.sqe.tests.javax.mail.util.MailTest;

/**
 * This class tests the <strong>addHeaderLine()</strong> API.
 * It does by passing various valid input values and then checking
 * the type of the returned object.	<p>
 *
 *	     Add an RFC822 header line to the header store.  <p>
 * api2test: public void addHeaderLine(String); <p>
 *
 * how2test: Call API with various arguments, then verify by calling getHeader() api and
 *	     comparing the 'add/'get' values. If they are equal then testcase passes,
 *	     otherwise it fails.
 *
 */

public class addHeaderLine_Test extends MailTest {

    public static String[] headerline = { "Date: Fri Dec  5 17:48:51 PST 1997-1998","From: tester@sun.com","Subject: JavaMail testing","To: Javamail@sun.com","Cc: editor@javaworld.com" };
    
    public static void main( String argv[] )
    {
        addHeaderLine_Test test = new addHeaderLine_Test();
        Status s = test.run(argv, System.err, System.out);
	s.exit();
    }

    public Status run(String argv[], PrintWriter log, PrintWriter out)
    {
	super.run(argv, log, out);
	parseArgs(argv);	// parse command-line options

        out.println("\nTesting class InternetHeaders: addHeaderLine(String)\n");

        try {
	  // create internetheader object
	     InternetHeaders ih = new InternetHeaders();
		  
	     if( ih == null ) {
		 return Status.failed("Warning: failed to created InternetHeaders object");
	     }
	  // BEGIN UNIT TEST:
	     // add header 'name|value' pairs

	     for( int i = 0; i < 5; i++ )
	     {
		  out.println("UNIT TEST "+ i +":  addHeaderLine("+ headerline[i] +")");
		  ih.addHeaderLine(headerline[i]);	// API TEST
	     }
	    // get all headerlines
	     Enumeration allheaders = ih.getAllHeaderLines();

	     while( allheaders.hasMoreElements() ) {
		    String headers = (String)allheaders.nextElement();
		    out.println(headers);
	     }
	     out.println("ALL UNIT TEST: passed");
	  // END UNIT TEST:
             checkStatus();

        } catch ( Exception e ) {
	     handlException(e);
        }
	return status;
     }
}
