/*
 * Copyright (c) 2002-2015 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.javax.mail.search.SentDateTerm;

import java.io.*;
import java.util.*;
import javax.mail.*;
import javax.mail.internet.*;
import javax.mail.search.*;
import com.sun.javatest.*;
import javasoft.sqe.tests.javax.mail.util.MailTest;

/**
 * This class tests the <strong>SentDateTerm()</strong> API.
 * It does this by passing various valid input values and then checking
 * the type of the returned object.	<p>
 *
 *		A contructor that takes an integer and date arguments. <p>
 * api2test: public SentDateTerm(int, Date)  <p>
 *		The match method.   <p>
 * api2test: boolean match(Message)  <p>
 *
 * how2test: Call these APIs with int/date/message arguments and if 'match'
 *	     returns boolean value, then this testcase passes.
 */

public class sentdateterm_Test extends MailTest {

    public static void main( String argv[] )
    {
        sentdateterm_Test test = new sentdateterm_Test();
        Status s = test.run(argv, System.err, System.out);
	s.exit();
    }

    public Status run(String argv[], PrintWriter log, PrintWriter out)
    {
	super.run(argv, log, out);
	parseArgs(argv);	// parse command-line options

        out.println("\nTesting class SentDateTerm: SentDateTerm(int, Date)\n");

        try {
          // Connect to host server
             Store store = connect2host(protocol, host, user, password);

          // Get a Folder object
	     Folder root = getRootFolder(store);
             Folder folder = root.getFolder(mailbox);

             if ( folder == null ) {
                  return Status.failed("Invalid folder object!");
             }
             folder.open(Folder.READ_ONLY);

	     if( msgcount == -1 ) {
                 msgcount = folder.getMessageCount();
                 if( msgcount < 1 )
                     return Status.failed("Mail folder is empty!");
             }
	     boolean foundit;

             for( int i = 1; i <= msgcount; i++ )
             {
             // Get the message
                MimeMessage msg =  (MimeMessage)folder.getMessage(i);

	        if( msg == null ) {
		    log.println("WARNING: FAILED TO GET MESSAGE NUMBER: "+ i);
		    continue;
	        }
		Date sentDate = msg.getSentDate();

             // BEGIN UNIT TEST:
                out.println("UNIT TEST "+ i +":  SentDateTerm(ComparisonTerm.EQ, "+ sentDate +")");

                SentDateTerm sdt = new SentDateTerm(ComparisonTerm.EQ, sentDate);    // API TEST

                if( sdt == null ) {
                    log.println("Warning: SentDateTerm contructor returned a Null object!");
		    continue;
                } else
                      out.println("UNIT TEST "+ i +": passed\n");

	        out.println("UNIT TEST "+ i +":  match(Message)");

		// match the message number
		foundit = sdt.match(msg);	// API TEST

	        if( foundit ) {
	            out.println("Expected sent date found in message header.");
                    out.println("UNIT TEST "+ i +":  passed\n");
	        } else {
		        out.println("Expected sent date not found in message header!");
			out.println("UNIT TEST "+ i +":  passed\n");
	        }
	     // END UNIT TEST:
	     }
	     folder.close(false);
	     store.close();
	     status = Status.passed("OKAY");

        } catch ( Exception e ) {
             handlException(e);
        }
	return status;
     }
}
