/*
 * Decompiled with CFR 0.152.
 */
package org.freebxml.omar.common.security;

import com.sun.xml.wss.MessageConstants;
import com.sun.xml.wss.MessageFilter;
import com.sun.xml.wss.SecurableSoapMessage;
import com.sun.xml.wss.SecurityEnvironment;
import com.sun.xml.wss.SecurityHeader;
import com.sun.xml.wss.SecurityToken;
import com.sun.xml.wss.X509SecurityToken;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.filter.FilterBase;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import javax.xml.namespace.QName;

public class ExtendedImportCertificateTokenFilter
extends FilterBase
implements MessageFilter {
    private boolean validateCert = true;
    private X509Certificate lastCert;
    static /* synthetic */ Class class$com$sun$xml$wss$X509SecurityToken;

    public void process(SecurableSoapMessage secureMessage) throws XWSSecurityException {
        X509Certificate cert;
        this.lastCert = null;
        SecurityHeader wsseSecurity = secureMessage.findSecurityHeader();
        X509SecurityToken token = null;
        try {
            token = (X509SecurityToken)wsseSecurity.getCurrentHeaderBlock(class$com$sun$xml$wss$X509SecurityToken == null ? (class$com$sun$xml$wss$X509SecurityToken = ExtendedImportCertificateTokenFilter.class$("com.sun.xml.wss.X509SecurityToken")) : class$com$sun$xml$wss$X509SecurityToken);
        }
        catch (XWSSecurityException ex) {
            throw SecurableSoapMessage.newSOAPFaultException((QName)MessageConstants.WSSE_INVALID_SECURITY_TOKEN, (String)"Exception while importing X509Certificate Token", (Throwable)ex);
        }
        String tokenId = token.getId();
        secureMessage.setToken(tokenId, (SecurityToken)token);
        secureMessage.setFilterParameter("TokenId", (Object)tokenId);
        secureMessage.setFilterParameter("Token", (Object)token);
        try {
            SecurityEnvironment secEnv;
            cert = token.getCertificate();
            if (this.validateCert && !(secEnv = secureMessage.getSecurityEnvironment()).validateCertificate(cert)) {
                throw new XWSSecurityException("Certificate validation failed");
            }
        }
        catch (XWSSecurityException xwsse) {
            FilterBase.log.log(Level.SEVERE, "WSS0156.exception.in.cert.validate", new Object[]{xwsse.getMessage()});
            throw SecurableSoapMessage.newSOAPFaultException((QName)MessageConstants.WSSE_INVALID_SECURITY_TOKEN, (String)xwsse.getMessage(), (Throwable)xwsse);
        }
        this.lastCert = cert;
    }

    public X509Certificate getLastCert() {
        return this.lastCert;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

