/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: TSJMSObjectsInterface.java 63802 2011-10-19 12:14:33Z af70133 $
 */

package com.sun.ts.lib.porting;

import javax.jms.*;

/**
 * This is the TSJMSObjectsInterface. An implementation of this interface 
 * must be provided by each JMS implementation to support their own 
 * implementation of getting administered objects.
 *
 */
public interface TSJMSObjectsInterface
{
    /**
     * This method allows JMS implementation to get Queue
     */

    public Queue getQueue(String name) throws Exception;



    /**
     * This method allows JMS implementation to get Topic
     */

    public Topic getTopic(String name) throws Exception;



    /**
     * This method allows JMS implementation to get TopicConnectionFactory
     */

    public TopicConnectionFactory getTopicConnectionFactory(String name) 
                                  throws Exception;



    /**
     * This method allows JMS implementation to get QueueConnectionFactory
     */

    public QueueConnectionFactory getQueueConnectionFactory(String name) 
                                  throws Exception;


    /**
     * This method allows JMS implementation to get ConnectionFactory
     */

    public ConnectionFactory getConnectionFactory(String name) 
                                  throws Exception;

}

