/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: W2JRLR2739Client.java 62536 2011-04-15 16:35:14Z af70133 $
 */

/* Copyright (c) 2003 Oracle Corporation.  All rights reserved.  */
package com.sun.ts.tests.jaxrpc.wsi.w2j.rpc.literal.R2739;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.tests.jaxrpc.sharedclients.SOAPClient;
import com.sun.ts.tests.jaxrpc.wsi.constants.CTSConstants;

public class W2JRLR2739Client extends SOAPClient{

    public W2JRLR2739Client(String webServerHost, int port, int mode) throws EETest.Fault{
        super(webServerHost, port, mode);
        stubContext.setNamespace("http://simpletestservice.org/wsdl");
        stubContext.setService("SimpleTest");
        stubContext.setPortPrefix("SimpleEndpoint");
        stubContext.setServiceInterface(SimpleEndpoint.class);
    }

    protected String getEndpointURLProperty() {
        return CTSConstants.w2jrlr2739EndpointProperty;
    }

    protected String getWSDLURLProperty() {
        return CTSConstants.w2jrlr2739WSDLProperty;
    }

    public String helloWorld() throws Exception{
        return ((SimpleEndpoint)stubContext.getStub()).helloWorld();
    }
}
