/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.exclude;

import com.sun.tdk.signaturetest.Exclude;
import com.sun.tdk.signaturetest.ExcludeException;
import com.sun.tdk.signaturetest.SignatureTest;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class ExcludeList
implements Exclude {
    private List excludeList = new ArrayList();

    public void addSignature(String name) {
        String regpack1 = name.replaceAll("(\\.|\\(|\\)|\\{|\\}|\\[|\\]|\\%|\\$)", "\\\\$1");
        String regpack = regpack1.replaceAll("\\\\\\\\", "");
        try {
            this.excludeList.add(Pattern.compile(regpack));
        }
        catch (PatternSyntaxException e) {
            SignatureTest.log.println("Error in -ExcludeSig: " + e.getMessage());
        }
    }

    public void check(String testedClassName, String name) throws ExcludeException {
        Iterator i = this.excludeList.iterator();
        while (i.hasNext()) {
            Pattern p = (Pattern)i.next();
            Matcher m = p.matcher(name);
            if (!m.matches()) continue;
            throw new ExcludeException(p.pattern());
        }
    }

    public Vector parseParameters(Vector args) {
        Vector<String> commonParameters = new Vector<String>();
        Enumeration e = args.elements();
        while (e.hasMoreElements()) {
            String parameter = (String)e.nextElement();
            if (parameter.equalsIgnoreCase("-excludesig")) {
                if (!e.hasMoreElements()) continue;
                String s = (String)e.nextElement();
                this.addSignature(s);
                continue;
            }
            commonParameters.addElement(parameter);
        }
        return commonParameters;
    }

    public String report() {
        return "finished";
    }
}

