/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.EnumSet;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum AttributeRight {
    SEARCH("search"),
    READ("read"),
    COMPARE("compare"),
    WRITE("write"),
    SELFWRITE_ADD("selfwrite_add"),
    SELFWRITE_DELETE("selfwrite_delete"),
    PROXY("proxy");

    private final String name;

    private AttributeRight(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static AttributeRight forName(String name) {
        String lowerName = StaticUtils.toLowerCase(name);
        for (AttributeRight r : EnumSet.allOf(AttributeRight.class)) {
            if (!r.name.equals(lowerName)) continue;
            return r;
        }
        return null;
    }

    public String toString() {
        return this.name;
    }
}

