/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.WebRequestSettings;
import com.gargoylesoftware.htmlunit.WebResponse;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.util.DateParseException;
import org.apache.commons.httpclient.util.DateUtil;
import org.apache.commons.lang.math.NumberUtils;
import org.mozilla.javascript.Script;
import org.w3c.dom.css.CSSStyleSheet;

public class Cache
implements Serializable {
    private static final long serialVersionUID = -3864114727885057419L;
    private int maxSize_ = 25;
    private final Map<String, Entry> entries_ = Collections.synchronizedMap(new HashMap(this.maxSize_));

    public void cacheIfPossible(WebRequestSettings request, WebResponse response, Script script) {
        if (this.isCacheable(request, response)) {
            String url = response.getUrl().toString();
            Entry entry = new Entry(url, script);
            this.entries_.put(entry.key_, entry);
            this.deleteOverflow();
        }
    }

    public void cache(String css, CSSStyleSheet styleSheet) {
        Entry entry = new Entry(css, styleSheet);
        this.entries_.put(entry.key_, entry);
        this.deleteOverflow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteOverflow() {
        Map<String, Entry> map = this.entries_;
        synchronized (map) {
            while (this.entries_.size() > this.maxSize_) {
                Entry oldestEntry = Collections.min(this.entries_.values());
                this.entries_.remove(oldestEntry.key_);
            }
        }
    }

    protected boolean isCacheable(WebRequestSettings request, WebResponse response) {
        return HttpMethod.GET == response.getRequestMethod() && this.isJavaScript(response) && !this.isDynamicContent(response);
    }

    protected boolean isDynamicContent(WebResponse response) {
        Date lastModified = this.parseDateHeader(response, "Last-Modified");
        Date expires = this.parseDateHeader(response, "Expires");
        long delay = 600000L;
        long now = System.currentTimeMillis();
        boolean cacheableContent = expires != null && expires.getTime() - now > 600000L || expires == null && lastModified != null && now - lastModified.getTime() > 600000L;
        return !cacheableContent;
    }

    protected Date parseDateHeader(WebResponse response, String headerName) {
        String value = response.getResponseHeaderValue(headerName);
        Date date = null;
        if (value != null) {
            try {
                date = DateUtil.parseDate((String)value);
            }
            catch (DateParseException e) {
                // empty catch block
            }
        }
        return date;
    }

    protected boolean isJavaScript(WebResponse webResponse) {
        String contentType = webResponse.getContentType().toLowerCase();
        return "text/javascript".equals(contentType) || "application/x-javascript".equals(contentType) || webResponse.getUrl().getPath().endsWith(".js");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Script getCachedScript(WebRequestSettings request) {
        if (HttpMethod.GET != request.getHttpMethod()) {
            return null;
        }
        Entry cachedEntry = this.entries_.get(request.getUrl().toString());
        if (cachedEntry == null) {
            return null;
        }
        Map<String, Entry> map = this.entries_;
        synchronized (map) {
            cachedEntry.touch();
        }
        return (Script)cachedEntry.value_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CSSStyleSheet getCachedStyleSheet(String css) {
        Entry cachedEntry = this.entries_.get(css);
        if (cachedEntry == null) {
            return null;
        }
        Map<String, Entry> map = this.entries_;
        synchronized (map) {
            cachedEntry.touch();
        }
        return (CSSStyleSheet)cachedEntry.value_;
    }

    public int getMaxSize() {
        return this.maxSize_;
    }

    public void setMaxSize(int maxSize) {
        if (maxSize < 0) {
            throw new IllegalArgumentException("Illegal value for maxSize: " + maxSize);
        }
        this.maxSize_ = maxSize;
        this.deleteOverflow();
    }

    public int getSize() {
        return this.entries_.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<String, Entry> map = this.entries_;
        synchronized (map) {
            this.entries_.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Entry
    implements Comparable<Entry>,
    Serializable {
        private static final long serialVersionUID = 588400350259242484L;
        private final String key_;
        private final Object value_;
        private long lastAccess_;

        Entry(String key, Object value) {
            this.key_ = key;
            this.value_ = value;
            this.lastAccess_ = System.currentTimeMillis();
        }

        @Override
        public int compareTo(Entry other) {
            return NumberUtils.compare((float)this.lastAccess_, (float)other.lastAccess_);
        }

        public void touch() {
            this.lastAccess_ = System.currentTimeMillis();
        }
    }
}

