/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript;

import com.gargoylesoftware.htmlunit.WebAssert;
import org.apache.commons.logging.Log;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;

public class StrictErrorReporter
implements ErrorReporter {
    private final Log log_;

    public StrictErrorReporter(Log log) {
        WebAssert.notNull("log", log);
        this.log_ = log;
    }

    public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
        this.log_.warn((Object)this.format("warning", message, sourceName, line, lineSource, lineOffset));
    }

    public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
        this.log_.error((Object)this.format("error", message, sourceName, line, lineSource, lineOffset));
        throw new EvaluatorException(message, sourceName, line, lineSource, lineOffset);
    }

    public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
        this.log_.error((Object)this.format("runtimeError", message, sourceName, line, lineSource, lineOffset));
        return new EvaluatorException(message, sourceName, line, lineSource, lineOffset);
    }

    private String format(String prefix, String message, String sourceName, int line, String lineSource, int lineOffset) {
        return prefix + ": message=[" + message + "] sourceName=[" + sourceName + "] line=[" + line + "] lineSource=[" + lineSource + "] lineOffset=[" + lineOffset + "]";
    }
}

