/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

final class WindowController {
    private static final int DEFAULT_INITIAL_WINDOW_SIZE = 65535;
    private int connectionWindowSize;
    private final Map<Integer, Integer> streams = new HashMap<Integer, Integer>();
    private final ReentrantLock controllerLock = new ReentrantLock();
    private final Condition notExhausted = this.controllerLock.newCondition();

    WindowController() {
        this.connectionWindowSize = 65535;
    }

    WindowController(int n) {
        this.connectionWindowSize = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerStream(int n, int n2) {
        this.controllerLock.lock();
        try {
            Integer n3 = this.streams.put(n, n2);
            if (n3 != null) {
                throw new InternalError("Unexpected entry [" + n3 + "] for streamid: " + n);
            }
        }
        finally {
            this.controllerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeStream(int n) {
        this.controllerLock.lock();
        try {
            boolean bl;
            Integer n2 = this.streams.remove(n);
            boolean bl2 = bl = n % 2 == 1;
            if (n2 == null && bl) {
                throw new InternalError("Expected entry for streamid: " + n);
            }
            if (n2 != null && !bl) {
                throw new InternalError("Unexpected entry for streamid: " + n);
            }
        }
        finally {
            this.controllerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int tryAcquire(int n, int n2) throws InterruptedException {
        this.controllerLock.lock();
        try {
            int n3 = 0;
            Integer n4 = 0;
            while (n3 <= 0) {
                n4 = this.streams.get(n2);
                if (n4 == null) {
                    throw new InternalError("Expected entry for streamid: " + n2);
                }
                n3 = Math.min(n, Math.min(n4, this.connectionWindowSize));
                if (n3 > 0) continue;
                this.notExhausted.await();
            }
            n4 = n4 - n3;
            this.streams.put(n2, n4);
            this.connectionWindowSize -= n3;
            int n5 = n3;
            return n5;
        }
        finally {
            this.controllerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean increaseConnectionWindow(int n) {
        this.controllerLock.lock();
        try {
            int n2 = this.connectionWindowSize;
            if ((n2 += n) < 0) {
                boolean bl = false;
                return bl;
            }
            this.connectionWindowSize = n2;
            this.notExhausted.signalAll();
        }
        finally {
            this.controllerLock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean increaseStreamWindow(int n, int n2) {
        this.controllerLock.lock();
        try {
            Integer n3 = this.streams.get(n2);
            if (n3 == null) {
                throw new InternalError("Expected entry for streamid: " + n2);
            }
            if ((n3 = Integer.valueOf(n3 + n)) < 0) {
                boolean bl = false;
                return bl;
            }
            this.streams.put(n2, n3);
            this.notExhausted.signalAll();
        }
        finally {
            this.controllerLock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void adjustActiveStreams(int n) {
        assert (n != 0);
        this.controllerLock.lock();
        try {
            for (Map.Entry<Integer, Integer> entry : this.streams.entrySet()) {
                int n2 = entry.getKey();
                if (n2 == 0 || n2 % 2 == 0) continue;
                Integer n3 = entry.getValue();
                n3 = n3 + n;
                this.streams.put(n2, n3);
            }
        }
        finally {
            this.controllerLock.unlock();
        }
    }

    int connectionWindowSize() {
        this.controllerLock.lock();
        try {
            int n = this.connectionWindowSize;
            return n;
        }
        finally {
            this.controllerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int streamWindowSize(int n) {
        this.controllerLock.lock();
        try {
            Integer n2 = this.streams.get(n);
            if (n2 == null) {
                throw new InternalError("Expected entry for streamid: " + n);
            }
            int n3 = n2;
            return n3;
        }
        finally {
            this.controllerLock.unlock();
        }
    }
}

