/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id$ 
 */

package com.sun.ts.tests.jaxrs.api.client.clientresponsecontext;

import javax.ws.rs.ext.RuntimeDelegate.HeaderDelegate;

import com.sun.ts.tests.jaxrs.common.provider.StringBean;

/**
 * Header Delegate for getHeaderStringIsEmptyTest
 */
public class NullStringBeanHeaderDelegate implements HeaderDelegate<StringBean> {

	@Override
	public StringBean fromString(String arg0) throws IllegalArgumentException {
		return new StringBean(arg0);
	}

	@Override
	public String toString(StringBean arg0) throws IllegalArgumentException {
		// By design. We need to set header as a no value
		// so that then the ClientResponseContext.getHeaderString should return
		// an empty string
		return null;
	}

}
