/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id$ 
 */

package com.sun.ts.tests.jaxrs.api.rs.bindingpriority;

import java.io.IOException;

import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.ext.Provider;

import com.sun.ts.lib.harness.EETest.Fault;

@Provider
public class ContextProvider implements ClientRequestFilter {

	protected void checkFilterContext(ClientRequestContext context)
			throws Fault {
		throw new Fault("this TCK method is not implemented yet");
	}

	@Override
	public void filter(ClientRequestContext context) throws IOException {
		try {
			checkFilterContext(context);
		} catch (Fault e) {
			throw new IOException(e);
		}
	}
	
	/**
	 * @param conditionTrue
	 * @param message
	 * @throws Fault
	 * 		when conditionTrue is not met with message provided
	 */
	protected static void //
	assertFault(boolean conditionTrue, Object... message) throws Fault {
		if (!conditionTrue) {
			StringBuilder sb = new StringBuilder();
			for (Object msg : message)
				sb.append(msg).append(" ");
			throw new Fault(sb.toString());
		}
	}	

}
