/*
 * Copyright (c) 2012, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: InterceptorCallbackMethods.java 69965 2013-02-13 12:02:10Z supol $ 
 */

package com.sun.ts.tests.jaxrs.api.rs.ext.interceptor;

import java.io.IOException;

/**
 * Every InterceptorContext has different way to get header OPERATION, proceed,
 * or write an entity to a response. Therefore, TemplateInterceptorBody is given
 * the implementation of this interface so that it can abstractly call these
 * methods no matter the given context.
 * 
 * It is passed as an argument to the only call-able method
 * {@link TemplateInterceptorBody#executeMethod()}
 */
public interface InterceptorCallbackMethods {
	void writeEntity(String entity);

	Object proceed() throws IOException;

	String getHeaderString();
}
