/*
 * Copyright (c) 2013, 2015 Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: StringSource.java 74550 2015-06-22 14:33:56Z jsupol $ 
 */

package com.sun.ts.tests.jaxrs.common.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

import javax.xml.transform.stream.StreamSource;

public class StringSource extends StreamSource {

	private String source;

	@Override
	public String getSystemId() {
		return source;
	}

	public StringSource(String source) {
		super();
		this.source = "<stringsource>" + source + "</stringsource>";
	}

	@Override
	public void setSystemId(String arg0) {
		this.source = arg0;
	}

	@Override
	public InputStream getInputStream() {
		ByteArrayInputStream bais = new ByteArrayInputStream(source.getBytes());
		return bais;
	}

	@Override
	public Reader getReader() {
		InputStreamReader reader = new InputStreamReader(getInputStream());
		return reader;
	}
	
	@Override
	public String getPublicId() {	
		return getSystemId();
	}

}
