/*
 * Copyright (c) 2012, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: PrintingErrorHandler.java 69965 2013-02-13 12:02:10Z supol $ 
 */

package com.sun.ts.tests.jaxrs.common.provider;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

@Provider
public class PrintingErrorHandler implements ExceptionMapper<Throwable> {

	@Override
	public Response toResponse(Throwable throwable) {
		throwable.printStackTrace();

		Writer result = new StringWriter();
		PrintWriter printWriter = new PrintWriter(result);
		throwable.printStackTrace(printWriter);
		return Response.status(Status.NOT_ACCEPTABLE).entity(result.toString())
				.build();
	}

}
