/*
 * Copyright (c) 2014, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id: ServerSideWriter.java 73547 2014-02-26 20:08:48Z supol $
 */

package com.sun.ts.tests.jaxrs.ee.rs.constrainedto;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;

@Provider
@ConstrainedTo(value = RuntimeType.SERVER)
public class ServerSideWriter implements MessageBodyReader<String> {

	public static final String FAKE_MESSAGE = "The fake writer on server side";
	public static final MediaType MEDIA_TYPE = new MediaType("writer",
			"serverside");

	@Override
	public boolean isReadable(Class<?> type, Type genericType,
			Annotation[] annotations, MediaType mediaType) {
		return mediaType.equals(MEDIA_TYPE);
	}

	@Override
	public String readFrom(Class<String> type, Type genericType,
			Annotation[] annotations, MediaType mediaType,
			MultivaluedMap<String, String> httpHeaders, InputStream entityStream)
			throws IOException, WebApplicationException {
		return FAKE_MESSAGE;
	}

}
